function md=solve(md,varargin)
%SOLVE - apply solution sequence for this model
%
%   Usage:
%      md=solve(md,varargin)
%      where varargin is a lit of paired arguments of string OR enums
%      arguments can be: 'analysis_type': 'DiagnosticAnalysis','ThermalAnalysis','PrognosticAnalysis','Transient2DAnalysis'
%      arguments can be: 'sub_analysis_type': 'Transient2DAnalysis','SteadyAnalysis','NoneAnalysisEnum'
%
%   Examples:
%      md=solve(md,'analysis_type',DiagnosticSolutionEnum);
%      md=solve(md,'analysis_type','ThermalAnalysis','sub_analysis_type','Transient2DAnalysis');
%      md=solve(md,'analysis_type',ThermalSolutionEnum,'sub_analysis_type',SteadyAnalysisEnum);
%      md=solve(md,'analysis_type','ThermalAnalysis');

%some checks on list of arguments
global ISSM_DIR

%recover options
options=pairoptions(varargin{:});

%add default options
options=process_solve_options(options);

%recover some fields
md.analysis_type=options.analysis_type;
md.sub_analysis_type=options.sub_analysis_type;

%check model consistency
displaystring(md.verbose,'\n%s\n','checking model consistency');
ismodelselfconsistent(md),

%preprocesses model before solving
md=presolve(md);

%if running qmu analysis, some preprocessing of dakota files using 
%models fields needs to be carried out. 
if md.qmu_analysis,
	md=preqmu(md,options);
end

%Save model as is (in case of a crash)
assignin('base',inputname(1),md);

displaystring(md.verbose,'\n%s\n','launching solution sequence');

%If running in parallel, we have a different way of launching the solution
%sequences. 
if ~strcmpi(md.cluster,'none'),
	md=solveparallel(md,options);
	return;
end

%Launch correct solution sequence
md=issm(md,md.analysis_type);

%post processes qmu results if necessary
if md.qmu_analysis,
	md=postqmu(md);
	cd ..
	system(['rm -rf qmu' num2str(GetPId)]);
end

%Check result is consistent
displaystring(md.verbose,'%s\n','checking result consistency');
%if ~isresultconsistent(md,options.analysis_type),
%	disp('!! results not consistent correct the model !!') %it would be very cruel to put an error, it would kill the computed results (even if not consistent...)
%end

%convert analysis type to string finally
md.analysis_type=EnumAsString(options.analysis_type);
md.sub_analysis_type=EnumAsString(options.sub_analysis_type);
