md=mesh(model,'../Exp/Square.exp',150000);
md=geography(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=setelementstype(md,'macayeal','all');
md.cluster='none';
md.rho_ice=10^7; %involved in the mass flux, make it easy
md.thickness(:)=1; %make it easy

%constrain all velocities to 1 m/yr, in the y-direction
md.spcvelocity(:,1:3)=1;
md.spcvelocity(:,4)=0;
md.spcvelocity(:,5)=1;
md.spcvelocity(:,6)=0;

%Dakota options
md.variables.nuv=normal_uncertain.empty();
md.variables.nuv(end+1)=normal_uncertain('DragCoefficient',1,0.01);

md.responses=struct();
md.responses.rf =response_function.empty();
md.responses.rf (end+1)=response_function('MaxVel',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.rf (end+1)=response_function('MassFlux1',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.rf (end+1)=response_function('MassFlux2',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.rf (end+1)=response_function('MassFlux3',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.rf (end+1)=response_function('MassFlux4',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.rf (end+1)=response_function('MassFlux5',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);
md.responses.rf (end+1)=response_function('MassFlux6',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);

%mass flux profiles
md.qmu_mass_flux_profiles={'../Exp/MassFlux1.exp','../Exp/MassFlux2.exp','../Exp/MassFlux3.exp','../Exp/MassFlux4.exp','../Exp/MassFlux5.exp','../Exp/MassFlux6.exp'};
md.qmu_mass_flux_profile_directory=pwd;

md.qmu_method     =dakota_method('nond_l');

md.qmu_params.direct=true;
md.qmu_params.analysis_driver='diagnostic';
md.qmu_params.evaluation_concurrency=1;
md.qmu_params.interval_type='forward';
md.qmu_params.tabular_graphics_data=true;

%partitioning
md.npart=20;
md=partitioner(md,'package','chaco','npart',md.npart,'weighting','on');
md.part=md.part-1;
md.qmu_analysis=1;

md.eps_rel=10^-10; %tighten for qmu analyses

md=solve(md,'analysis_type',DiagnosticSolutionEnum,'overwrite','y');
