/* \file ModelProcessorx.h
 * \brief  Header file for model processor
 */

#ifndef _MODEL_PROCESSORX_H_
#define _MODEL_PROCESSORX_H_

#define RIFTINFOSIZE 11

class DataSet;
class IoModel;
class Parameters;
#include "../../io/io.h"

void ModelProcessorx(Elements** pelements, Nodes** pnodes, Vertices** pvertices, Materials** pmaterials, Constraints** pconstraints, Loads** ploads, Parameters** pparameters, ConstDataHandle iomodel_handle,const int solution_type,const int nummodels,const int* analysis_type_list);

/*Creation of fem datasets: general drivers*/
void  CreateDataSets(Elements** pelements,Nodes** pnodes,Vertices** pvertices, Materials** pmaterials, Constraints** pconstraints, Loads** ploads,Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,const int solution_type,int analysis_type,const int nummodels,int analysis_counter);
void  CreateElementsVerticesAndMaterials(Elements** pelements,Vertices** pvertices,Materials** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle,const int nummodels);
void  CreateParameters(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,const int solution_type,int analysis_type,int analysis_counter);
void  CreateParametersControl(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int solution_type,int analysis_type);
void  CreateParametersQmu(Parameters** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle,int solution_type,int analysis_type);

/*Creation of fem datasets: specialised drivers: */

/*diagnostic horizontal*/
void	CreateNodesDiagnosticHoriz(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticHoriz(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsDiagnosticHoriz(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticHoriz(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic vertical*/
void	CreateNodesDiagnosticVert(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticVert(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsDiagnosticVert(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticVert(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic hutter*/
void	CreateNodesDiagnosticHutter(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticHutter(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsDiagnosticHutter(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticHutter(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*diagnostic stokes*/
void	CreateNodesDiagnosticStokes(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsDiagnosticStokes(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsDiagnosticStokes(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsDiagnosticStokes(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*bed slope*/
void	CreateNodesBedSlope(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBedSlope(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsBedSlope(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsBedSlope(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*surface slope*/
void	CreateNodesSurfaceSlope(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsSurfaceSlope(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsSurfaceSlope(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsSurfaceSlope(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*thermal:*/
void	CreateNodesThermal(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsThermal(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsThermal(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsThermal(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*melting:*/
void	CreateNodesMelting(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsMelting(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsMelting(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsMelting(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*prognostic:*/
void	CreateNodesPrognostic(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsPrognostic(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsPrognostic(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsPrognostic(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*balancedthickness:*/
void	CreateNodesBalancedthickness(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedthickness(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsBalancedthickness(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsBalancedthickness(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*balancedvelocities:*/
void	CreateNodesBalancedvelocities(Nodes** pnodes,IoModel* iomodel_handle,ConstDataHandle iomodel_handle);
void	CreateConstraintsBalancedvelocities(Constraints** pconstraints,IoModel* iomodel,ConstDataHandle iomodel_handle);
void  CreateLoadsBalancedvelocities(Loads** ploads, IoModel* iomodel, ConstDataHandle iomodel_handle);
void	UpdateElementsBalancedvelocities(Elements* elements,IoModel* iomodel_handle,ConstDataHandle iomodel_handle,int analysis_counter,int analysis_type);

/*partitioning: */
void  ElementsAndVerticesPartitioning(bool** pmy_elements, bool** pmy_vertices, IoModel* iomodel, ConstDataHandle iomodel_handle);
void  NodesPartitioning(bool** pmy_nodes,bool* my_elements, bool* my_vertices,  IoModel* iomodel, ConstDataHandle iomodel_handle,bool continuous);

/*Connectivity*/
void  CreateSingleNodeToElementConnectivity(IoModel* iomodel);
void  CreateNumberNodeToElementConnectivity(IoModel* iomodel);

/*Diverse: */
void  SortDataSets(Elements** pelements,Nodes** pnodes,Vertices** pvertices, Loads** ploads, Materials** pmaterials, Constraints** pconstraints, Parameters** pparameters);
void  UpdateCounters(IoModel* iomodel,Nodes** pnodes,Loads** ploads, Constraints** pconstraints);

#endif
