md=mesh(model,'../Exp/Square.exp',300000);
md=geography(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=setelementstype(md,'macayeal','all');
md.cluster='none';

%Dakota options
md.variables.nuv=normal_uncertain.empty();
md.variables.nuv(end+1)=normal_uncertain('RhoIce',md.rho_ice,0.01);
md.variables.nuv(end+1)=normal_uncertain('DragCoefficient',1,0.01);

md.responses=struct();
md.responses.rf =response_function.empty();
md.responses.rf (end+1)=response_function('MaxVel',[],[0.0001 0.001 0.01 0.25 0.5 0.75 0.99 0.999 0.9999]);

md.qmu_method     =dakota_method('nond_l');

md.qmu_params.direct=true;
md.qmu_params.analysis_driver='diagnostic';
md.qmu_params.evaluation_concurrency=1;
md.qmu_params.interval_type='forward';
md.qmu_params.tabular_graphics_data=true;

md.part=0:1:md.numberofgrids-1;
md.part=md.part';
md.npart=md.numberofgrids;
md.qmu_analysis=1;

md.eps_rel=10^-10; %tighten for qmu analysese

md=solve(md,'analysis_type',DiagnosticSolutionEnum,'overwrite','y');
