function md=meshprocessoutsiderifts(md,domainoutline)
%MESHPROCESSOUTSIDERIFTS - process rifts when they touch the domain outline
%
%   Usage:
%      md=meshprocessoutsiderifts(md,domain)
%



%go through rifts, and figure out which ones touch the domain outline
for i=1:md.numrifts,
	
	%first, flag nodes that belong to the domain outline
	flags=ContourToMesh(md.elements,md.x,md.y,domainoutline,'node',0);

	rift=md.rifts(i);
	tips=rift.tips;
	outsidetips=tips(find(flags(rift.tips)==0));

	%we have found outsidetips, tips that touch the domain outline. go through them
	for j=1:length(outsidetips),
		
		tip=outsidetips(j);
		%find tip in the segments, take first segment (there should be 2) that holds tip, 
		%and grid_connected_to_tip is the other node on this segment:
		tipindex=find(rift.segments(:,1)==tip); 
		if length(tipindex),
			tipindex=tipindex(1);
			grid_connected_to_tip=rift.segments(tipindex,2);
		else
			tipindex=find(rift.segments(:,2)==tip); tipindex=tipindex(1);
			grid_connected_to_tip=rift.segments(tipindex,1);
		end

		%ok, we have the tip node, and the first node connected to it, on the rift. Now, 
		%identify all the elements that are connected to the tip, and that are on the same 
		%side of the rift.
		A=tip;
		B=grid_connected_to_tip;

		elements=[];

		while  flags(B), %as long as B does not belong to the domain outline, keep looking.
			%detect elements on edge A,B:
			edgeelements=ElementsFromEdge(md.elements,A,B);
			%rule out those we already detected
			already_detected=ismember(edgeelements,elements);
			nextelement=edgeelements(find(~already_detected));
			%add new detected element to the list of elements we are looking for.
			elements=[elements;nextelement];
			%new B:
			B=md.elements(nextelement,find(~ismember(md.elements(nextelement,:),[A B])));
		end
		
		%take the list of elements on one side of the rift that connect to the tip, 
		%and duplicate the tip on them, so as to open the rift to the outside.
		num=length(md.x)+1;
		md.x=[md.x;md.x(tip)];
		md.y=[md.y;md.y(tip)];
		md.numberofgrids=num;
		
		%replace tip in elements
		newelements=md.elements(elements,:);
		pos=find(newelements==tip);
		newelements(pos)=num;
		md.elements(elements,:)=newelements;
		md.rifts(i).tips=[md.rifts(i).tips num];

		%deal with segments
		tipsegments=find((md.segments(:,1)==tip) | (md.segments(:,2)==tip));
		for  k=1:length(tipsegments),
			segment_index=tipsegments(k);
			pos=find(md.segments(segment_index,1:2)~=tip);
			other_node=md.segments(segment_index,pos);
			if ~isconnected(md.elements,other_node,tip),
				pos=find(md.segments(segment_index,1:2)==tip);
				md.segments(segment_index,pos)=num;
			end
		end
	end
end


%Fill in rest of fields:
md.numberofelements=length(md.elements);
md.numberofgrids=length(md.x);
md.z=zeros(md.numberofgrids,1);
md.gridonboundary=zeros(length(md.x),1); md.gridonboundary(md.segments(:,1:2))=1;
md.numrifts=length(md.rifts);
md.elements_type=3*ones(md.numberofelements,1);
md.gridonbed=ones(md.numberofgrids,1);
md.gridonsurface=ones(md.numberofgrids,1);
md.elementonbed=ones(md.numberofelements,1);
md.elementonsurface=ones(md.numberofelements,1);
