function md=geography2(md,landname,iceshelfname,icesheetname)
%GEOGRAPHY2 - establish land, ice sheet and ice shelf areas in a domains.
%
%   Usage:
%      md=geography2(md,landname,iceshelfname,icesheetname)
%
%   Examples:
%      md=geography2(md,'LandName.exp','Iceshelves.exp','Islands.exp');

%Get assigned fields
x=md.x;
y=md.y;
elements=md.elements;

%recover elements and grids on land.
if ischar(landname),
	[gridonland,elementonland]=ContourToMesh(elements,x,y,landname,'element and node',2);
elseif isfloat(landname),
	if size(landname,1)~=md.numberofelements,
		error('Landname for area must be of same size as number of elements in model');
	end
	elementonland=landname;
	gridonland=zeros(md.numberofgrids,1);
	gridonland(md.elements(find(elementonland),:))=1;
else
	error('Invalid area option option');
end

%Now, build the connectivity tables for this mesh.
if size(md.nodeconnectivity,1)~=md.numberofgrids,
	md.nodeconnectivity=NodeConnectivity(md.elements,md.numberofgrids);
end
if size(md.elementconnectivity,1)~=md.numberofelements,
	md.elementconnectivity=ElementConnectivity(md.elements,md.nodeconnectivity);
end

%any element with 3 grids on land should be on land:
elementsonwater=find(~elementonland);
wrongelements=elementsonwater(find(( gridonland(md.elements(elementsonwater,1)) + gridonland(md.elements(elementsonwater,2)) + gridonland(md.elements(elementsonwater,3)) ...
                  )==3));
elementonland(wrongelements)=1;

%any element with its barycentre on land should be on land: (only if landname is an expfile)
if ischar(landname),
weights={[1;1;1],[2;1;1],[1;2;1],[1;1;2]};
	for i=1:length(weights),
		xelem=x(md.elements)*weights{i}/sum(weights{i});
		yelem=y(md.elements)*weights{i}/sum(weights{i});
	end
	baryonland=ContourToNodes(xelem,yelem,landname,1);
	pos=find(~baryonland); elementonland(pos)=0;
	pos=find(baryonland); elementonland(pos)=1;
end

%figure out which elements on land are actually in the middle of the ocean!
pos1=find(elementonland); 
connectedtoland=md.elementconnectivity(pos1,:);
pos=find(connectedtoland); connectedtoland(pos)=1-elementonland(connectedtoland(pos));
connectedtolandsum=sum(connectedtoland,2);
waterelements=pos1(find(connectedtolandsum==3));
elementonland(waterelements)=0;

%figure out which elements on water  are actually in the middle of the land!
pos1=find(~elementonland); 
connectedtowater=md.elementconnectivity(pos1,:);
pos=find(connectedtowater); connectedtowater(pos)=elementonland(connectedtowater(pos));
connectedtowatersum=sum(connectedtowater,2);
landelements=pos1(find(connectedtowatersum==3));
elementonland(landelements)=1;

%recover arrays of ice shelf grids and elements, and ice sheet grids and elements.
elementoniceshelf=FlagElements(md,iceshelfname);
elementonicesheet=FlagElements(md,icesheetname);

%Because icesheet grids and elements can be included into an iceshelf, we need to update. Remember, all the previous 
%arrays come from domain outlines that can intersect one another: 
gridoniceshelf=zeros(md.numberofgrids,1);
gridonicesheet=zeros(md.numberofgrids,1);
elementoniceshelf=double((elementoniceshelf & ~elementonicesheet));
elementonicesheet=double(~elementoniceshelf);
gridoniceshelf(md.elements(find(elementoniceshelf),:))=1;
gridonicesheet(md.elements(find(elementonicesheet),:))=1;

%now correct, so that none of the iceshelf and icesheet elements and nodes are in the water.
pos=find(~elementonland);
elementoniceshelf(pos)=0; 
elementonicesheet(pos)=0;

pos=find(~gridonland);
gridoniceshelf(pos)=0; 
gridonicesheet(pos)=0;

%create gridonwater and elementonwater: 
gridonwater=double(~gridonland);
elementonwater=double(~elementonland);

%correct for islands:
gridoniceshelf=double(gridoniceshelf & ~gridonicesheet);
elementoniceshelf=double(elementoniceshelf & ~elementonicesheet);

%now, icesheets are everything except iceshelves and water
gridonicesheet=double(~gridoniceshelf & ~gridonwater);
elementonicesheet=double(~elementoniceshelf & ~elementonwater);

%Deal with segments on neumann:

%Get current connectivity
elementconnectivity=md.elementconnectivity;

%put 0 for elements on water
pos=find(elementconnectivity);
elementconnectivity(pos)=elementconnectivity(pos).*(~elementonwater(elementconnectivity(pos)));

%put line of ones for elements on water
pos=find(elementonwater);
elementconnectivity(pos,:)=1;% line of ones for elements on water so they won't be considered

%resort lines (zeros must be at the last column for findsegments)
elementconnectivity=sort(elementconnectivity,2,'descend');

%call findsegments to build segment using THIS conectivity
md.segments=findsegments(md,'elementconnectivity',elementconnectivity);

%some final checks: 
%check that no grid thinks it's on an ice shelf or ice sheet, and lies actually in the middle of the water.
gridsgrounded=find(~gridonwater);
lengthconnectivity=size(md.nodeconnectivity,2);
groundedcounters=md.nodeconnectivity(gridsgrounded,lengthconnectivity);
groundedconnectivity=md.nodeconnectivity(gridsgrounded,1:lengthconnectivity-1);
pos=find(groundedconnectivity);
groundedconnectivity(pos)=elementonwater(groundedconnectivity(pos));
groundedsum=sum(groundedconnectivity,2);
errorflags=find(groundedsum==groundedcounters);
errorgrids=gridsgrounded(errorflags);

gridonwater(errorgrids)=1;
gridonicesheet(errorgrids)=0;
gridoniceshelf(errorgrids)=0;

%Return: 
md.gridoniceshelf=gridoniceshelf;
md.elementoniceshelf=elementoniceshelf;

md.gridonwater=gridonwater;
md.elementonwater=elementonwater;

md.gridonicesheet=gridonicesheet;
md.elementonicesheet=elementonicesheet;

md.counter=2;
md.segmentmarkers(:)=1;
