/*!\file: Inputs.h
 * \brief prototypes for Inputs.h
 */ 

#ifndef _CONTAINER_INPUTS_H_
#define  _CONTAINER_INPUTS_H_

/*forward declarations */
class Materials;
class Parameters;
class Elements;
class Vertices;
class Loads;
class Nodes;
class DataSet;
class Input;
class Node;

class Inputs: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Inputs();
		Inputs(int enum_type);
		~Inputs();

		/*}}}*/
		/*numerics: {{{1*/
		int     AddInput(Input* in_input);
		void    ChangeEnum(int enumtype,int new_enumtype);
		void    ConstrainMin(int constrain_enum, double minimum);
		int     DeleteInput(int enum_type);
		void    DuplicateInput(int original_enum,int new_enum);
		Input*  GetInput(int enum_name);
		Inputs* SpawnTriaInputs(int* indices);
		void    AXPY(int YEnum, double scalar, int XEnum);
		
		void GetParameterAverage(double* pvalue, int enum_type);
		void GetParameterValue(bool* pvalue,int enum_type);
		void GetParameterValue(int* pvalue,int enum_type);
		void GetParameterValue(double* pvalue,int enum_type);
		void GetParameterValue(double* pvalue,double* gauss,int enum_type);
		void GetParameterValue(double* pvalue,double* gauss,int enum_type,double defaultvalue);
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type);
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type,double* defaultvalues);
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss,int enum_type);
		/*}}}*/

};

#endif //ifndef _INPUTS_H_
