#!/bin/bash

#prepare runs
#get configs {{{1
if [ $# -ne 1 ];
then
	#no config file specified: exit
	echo "no config file specified. Exiting..."
	exit 1
fi

#Go to init_Path and source config
INIT_PATH=$(cat $ISSM_DIR/TEMP/nightly.log | grep "init_path" | awk '{print $2}')
cd $INIT_PATH
source $1;
#}}}
#check NUMCPUS_RUN options {{{1
if [ "$NUMCPUS_RUN" = "" ]
then
	echo "NUMCPUS_RUN option not found, defaulting to NUMCPUS_RUN = 1"
	NUMCPUS_RUN=1
fi
#}}}
#create softlink to startup {{{1
cd $ISSM_DIR/test/NightlyRun/
ln -s $ISSM_DIR/startup.m .
#}}}

#Launch all tests on different cpus
for (( i=1;i<=$NUMCPUS_RUN;i++ ))
do
	#Launch matlab and the nightly run script
	cat > $ISSM_DIR/TEMP/matlab_run$i.m << EOF
	warning off %necessary to avoid a nightly.log of several Go for parallel runs
	try,
		cd $ISSM_DIR/test/NightlyRun
		startup;
		$(if [ "$NROPTIONS" = ""  ]
	then
		echo "runme('rank',$i,'numprocs',$NUMCPUS_RUN);"
	else
		echo "runme($NROPTIONS,'rank',$i,'numprocs',$NUMCPUS_RUN);"
	fi
	)
	catch me,
		%An error occured, get report and exit
		directory=strsplit(pwd,'/');
		message=getReport(me)
		fid=fopen([ISSM_DIR '/TEMP/matlaberror.log'], 'at');
		fprintf(fid,'\nMatlab error occured in: %s\n\n',directory{end});
		fprintf(fid,'%s',message);
		fclose(fid);
	end
	exit
EOF

	#Start run from TEMP directory
	cd $ISSM_DIR/TEMP/

	#Start test
	MATLAB_VERSION="7.6" #7.2,7.4,7.6 and 7.8
	/usr/local/pkgs/matlab-$MATLAB_VERSION/bin/matlab  -nojvm -nosplash  -r matlab_run$i -logfile matlab_log$i.log &

done

#wait until matlab closes
wait

#concatenate all reports
mv matlab_log1.log  matlab_log.log
for (( i=2;i<=$NUMCPUS_RUN;i++ ))
do
	cat matlab_log.log matlab_log$i.log > matlab_log.log.bak
	mv matlab_log.log.bak matlab_log.log
	rm matlab_log$i.log

done
