function dvar=QmuSetupDesign(dvar,variables,params,varargin)

%get descriptor
descriptor=variables.descriptor;

%loop on descriptor
if strcmpi(descriptor,'RhoIce')

	dvar=setuprhoice(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'RhoWater')

	dvar=setuprhowater(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'HeatCapacity')

	dvar=setupheatcapacity(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'ThermalConductivity')

	dvar=setupthermalconductivity(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'Gravity')

	dvar=setupgravity(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'Thickness')

	dvar=setupthickness(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'Surface')

	dvar=setupsurface(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'Bed')

	dvar=setupbed(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'DragCoefficient')

	dvar=setupdrag(dvar,variables,params,varargin{:});

elseif strncmpi(descriptor,'DragCoefficientNode',9)

	dvar=setupdrag_node(dvar,variables,params,varargin{:});

elseif strncmpi(descriptor,'ThicknessNode',14)

	dvar=setupthickness_node(dvar,variables,params,varargin{:});

elseif strcmpi(descriptor,'RiftsFriction')

	dvar=setupriftsfriction(dvar,variables,params,varargin{:});

else
	error(['QmuSetupDesign warning message: could not find ' descriptor ' setup design function']);
end

end
