%SaeRISE Antarctica

%Run steps
steps=[1 2 3];

%steps available: 
rs=runsteps('Models/','SeaRISE.Greenland.step#');
rs=addstep(rs,'Mesh generation');
rs=addstep(rs,'Parameterization');
rs=addstep(rs,'Control Method drag 1');

%Hard coded parameters
modeldatapath='./../../Data/';
%clustername=oshostname();
clustername='wilkes';
type='2d';

%Cluster parameters{{{1
if strcmpi(clustername,'pfe');
	cluster.name='pfe';      cluster.np=8*70; cluster.queue='long';  cluster.time=12*60;
elseif strcmpi(clustername,'cosmos')
	cluster.name='cosmos';   cluster.np=100;  cluster.queue='longq'; cluster.time=12*60;
elseif strcmpi(clustername,'larsen'),
	cluster.name='larsen';   cluster.np=8;    cluster.queue='long';  cluster.time=12*60;
else
	cluster.name=oshostname; cluster.np=8;   cluster.queue='long';  cluster.time=12*60;
	%cluster.name=oshostname; cluster.np=16;   cluster.queue='long';  cluster.time=12*60;
end%}}}

%some timing
t1=clock;

%Mesh generation {{{1
num=1;
if ismember(num,steps),
	message(rs,num)
	
	%Mesh parameters
	resolution=15000;

	%Initial mesh
	md=model;
	md=mesh(md,'DomainOutline.exp',resolution);

	savemodel(rs,num,md);
end %}}}
%Parameterization {{{1
num=num+1;
if ismember(num,steps),
	message(rs,num)
	md=loadmodel(rs,'Mesh generation');

	%Find ice sheets and ice shelves
	landcoveringpath=[modeldatapath '/thkmask.mat'];
	land_type=InterpFromFile(md.x,md.y,landcoveringpath,0);
	gridonicesheet=zeros(md.numberofgrids,1);
	gridonicesheet(find(land_type>0))=1;
	elementonicesheet=zeros(md.numberofelements,1);
	elementonicesheet(find(sum(gridonicesheet(md.elements(:,:)),2)==3))=1;
	elementoniceshelf=1-elementonicesheet;
	md=geography(md,elementoniceshelf,'');

	md=parameterize(md,'Antarctica.par');
	md=setelementstype(md,'macayeal','all');
	
	savemodel(rs,num,md);
end %}}}
%Control method drag 1 {{{
num=num+1;
if ismember(num,steps),
	message(rs,num)
	md=loadmodel(rs,'Parameterization');

	disp('Compute 2d drag coefficient');

	md.eps_abs=NaN;
	md.eps_cm=NaN;
	md.verbose=0;
	
	md.drag(:)=30;
	md.control_analysis=1;
	md.nsteps=10;
	md.maxiter=10*ones(md.nsteps,1);
	fit=[0;0;2;0];
	md.fit=repmat(fit,md.nsteps,1);
	md.fit(1:30)=2;
	md.fit(31:60)=0;
	md.fit(md.nsteps+1:end)=[];
	md.optscal=30*ones(md.nsteps,1);
	md.cm_jump=.99*ones(md.nsteps,1);
	md.control_type='drag';
	md.waitonlock=inf;
	md.cm_min=1;
	md.cm_max=200;

	%spc all 0 velocities.
	pos=find(md.vel_obs==0);
	npos=length(pos);
	md.spcvelocity(pos,:)=[ones(npos,1) ones(npos,1) ones(npos,1) zeros(npos,1) zeros(npos,1) zeros(npos,1)];

	md=setcluster(md,cluster);
	md=solve(md,'analysis_type','diagnostic');
	md.drag=md.results.diagnostic.parameter;

	savemodel(rs,num,md);
end %}}}

%timing
t2=clock; disp(sprintf('\n   %s\n',['run elapsed time: ' num2str(etime(t2,t1)) ' seconds']));
