/*\file InterpFromMeshToMesh2d.c
 *\brief: bamg module.
 */
#include "./InterpFromMeshToMesh2d.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input: */
	double* index=NULL;
	int     index_cols;

	double* x_data=NULL;
	int     x_data_rows;

	double* y_data=NULL;
	int     y_data_rows;

	double* data=NULL; 
	int     data_rows;
	int     data_cols;

	double* x_interp=NULL;
	double* y_interp=NULL;

	int     x_interp_rows;
	int     y_interp_rows;

	double default_value;

	/*Intermediary*/
	int nods_data;
	int nels_data;
	int nods_interp;
	int verbose=0;

	/* output: */
	double* data_interp=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InterpFromMeshToMesh2dUsage);

	/*Input datasets: */
	if (verbose) printf("Fetching inputs\n");
	FetchData(&index,&nels_data,&index_cols,INDEXHANDLE);
	FetchData(&x_data,&x_data_rows,NULL,XHANDLE);
	FetchData(&y_data,&y_data_rows,NULL,YHANDLE);
	FetchData(&data,&data_rows,&data_cols,DATAHANDLE);
	FetchData(&x_interp,&x_interp_rows,NULL,XINTERPHANDLE);
	FetchData(&y_interp,&y_interp_rows,NULL,YINTERPHANDLE);
	FetchData(&default_value,DEFAULTHANDLE);

	/*some checks*/
	if (verbose) printf("Checking inputs\n");
	if (x_data_rows!=y_data_rows){
		ISSMERROR("vectors x and y should have the same length!");
	}
	if (x_interp_rows!=y_interp_rows){
		ISSMERROR("vectors x_interp and y_interp should have the same length!");
	}
	if (index_cols!=3){
		ISSMERROR("index should have 3 columns (input provided has %i columns)",index_cols);
	}

	/*get number of elements and number of nodes in the data*/
	nods_data=x_data_rows;
	nods_interp=x_interp_rows;

	/* Run core computations: */
	if (verbose) printf("Call core\n");
	InterpFromMeshToMesh2dx(&data_interp,index,x_data,y_data,nods_data,nels_data,data,data_rows,data_cols,x_interp,y_interp,nods_interp,default_value);

	/*Write data: */
	WriteData(DATAINTERP,data_interp,nods_interp,data_cols);

	/*end module: */
	MODULEEND();
}

void InterpFromMeshToMesh2dUsage(void)
{
	_printf_("INTERFROMMESHTOMESH2D - interpolation from a 2d triangular mesh onto a list of point\n");
	_printf_("\n");
	_printf_("   This function is a multi-threaded mex file that interpolates a field\n");
	_printf_("   defined on a triangular mesh onto a list of point\n");
	_printf_("\n");
	_printf_("   Usage:\n");
	_printf_("      data_interp=InterpFromMeshToMesh2d(index,x,y,data,x_interp,y_interp,default_value);\n");
	_printf_("\n");
	_printf_("      index: index of the mesh where data is defined\n");
	_printf_("      x,y: coordinates of the nodes where data is defined\n");
	_printf_("      data: matrix holding the data to be interpolated onto the mesh. (one column per field)\n");
	_printf_("      x_interp,y_interp: coordinates of the points onto which we interpolate.\n");
	_printf_("      default_value: default value if no data is found (holes).\n");
	_printf_("      data_interp: vector of mesh interpolated data.\n");
	_printf_("\n");
	_printf_("   Example:\n");
	_printf_("      load('temperature.mat');\n");
	_printf_("      md.temperature=InterpFromMeshToMesh2d(index,x,y,temperature,md.x,md.y,253);\n");
	_printf_("\n");
}
