/*! \file Penta.h 
 *  \brief: header file for penta object
 */

#ifndef _PENTA_H_
#define _PENTA_H_

/*Headers:*/
/*{{{1*/
#include "./Element.h"
#include "./PentaHook.h"
#include "./PentaRef.h"
class  Object;
class Parameters;
class Inputs;
class IoModel;
class Node;
class Matice;
class Matpar;
class Tria;

#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
/*}}}*/

class Penta: public Element,public PentaHook,public PentaRef{

	public:

		int          id;

		Node       **nodes;        // 6 nodes
		Matice      *matice;       // 1 material ice
		Matpar      *matpar;       // 1 material parameter
		Penta      **neighbors;   // 2 neighbors: first one under, second one above

		Parameters  *parameters;   //pointer to solution parameters
		Inputs      *inputs;
		Results      *results;

		/*Penta constructors and destructor: {{{1*/
		Penta();
		Penta(int penta_id,int i, IoModel* iomodel,int nummodels);
		~Penta();
		/*}}}*/
		/*Object virtual functions definitions: {{{1*/
		Object*   copy();
		void	  DeepEcho();
		void	  Demarshall(char** pmarshalled_dataset);
		void	  Echo();
		int		  Enum();
		int		  Id(); 
		void	  Marshall(char** pmarshalled_dataset);
		int		  MarshallSize();
		int		  MyRank();
		/*}}}*/
		/*Update virtual functions definitions: {{{1*/
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromSolution(double* solutiong);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		/*}}}*/
		/*Element virtual functions definitions: {{{1*/
		void   ComputeBasalStress(Vec sigma_b);
		void   ComputePressure(Vec p_g);
		void   ComputeStrainRate(Vec eps);
		void   Configure(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		void   SetCurrentConfiguration(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		double CostFunction(bool process_units);
		void   CreateKMatrix(Mat Kgg);
		void   CreatePVector(Vec pg);
		void   DeleteResults(void);
		void   GetBedList(double* bed_list);
		void*  GetMatPar();
		void   GetNodes(void** nodes);
		bool   GetOnBed();
		bool   GetShelf(); 
		void   GetSolutionFromInputs(Vec solution);
		void   GetThicknessList(double* thickness_list);
		void   GetVectorFromInputs(Vec vector,int NameEnum);
		void   Gradj(Vec gradient,int control_type);
		void   GradjB(Vec gradient);
		void   GradjDrag(Vec gradient);
		void   InputControlUpdate(double scalar,bool save_parameter);
		bool   InputConvergence(double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums);
		void   InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum=ElementsEnum);
		void   InputDuplicate(int original_enum,int new_enum);
		void   InputScale(int enum_type,double scale_factor);
		void   InputToResult(int enum_type,int step,double time);
		double MassFlux(double* segment,bool process_units);
		void   MaxAbsVx(double* pmaxabsvx, bool process_units);
		void   MaxAbsVy(double* pmaxabsvy, bool process_units);
		void   MaxAbsVz(double* pmaxabsvz, bool process_units);
		void   MaxVel(double* pmaxvel, bool process_units);
		void   MaxVx(double* pmaxvx, bool process_units);
		void   MaxVy(double* pmaxvy, bool process_units);
		void   MaxVz(double* pmaxvz, bool process_units);
		void   MinVel(double* pminvel, bool process_units);
		void   MinVx(double* pminvx, bool process_units);
		void   MinVy(double* pminvy, bool process_units);
		void   MinVz(double* pminvz, bool process_units);
		double Misfit(bool process_units);
		void   PatchFill(int* pcount, Patch* patch);
		void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes);
		void   ProcessResultsUnits(void);
		double SurfaceArea(void);
		void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type);
		void   UpdateGeometry(void);
		/*}}}*/
		/*Penta specific routines:{{{1*/
		void	  CreateKMatrixBalancedthickness(Mat Kggg);
		void	  CreateKMatrixBalancedvelocities(Mat Kggg);
		void	  CreateKMatrixDiagnosticHoriz( Mat Kgg);
		void	  CreateKMatrixDiagnosticHutter( Mat Kgg);
		void	  CreateKMatrixDiagnosticStokes( Mat Kgg);
		void	  CreateKMatrixDiagnosticVert( Mat Kgg);
		void	  CreateKMatrixMelting(Mat Kggg);
		void	  CreateKMatrixPrognostic(Mat Kggg);
		void	  CreateKMatrixSlope(Mat Kggg);
		void	  CreateKMatrixThermal(Mat Kggg);
		void	  CreatePVectorBalancedthickness( Vec pg);
		void	  CreatePVectorBalancedvelocities( Vec pg);
		void	  CreatePVectorDiagnosticHoriz( Vec pg);
		void	  CreatePVectorAdjointHoriz( Vec pg);
		void	  CreatePVectorDiagnosticHutter( Vec pg);
		void	  CreatePVectorDiagnosticStokes( Vec pg);
		void	  CreatePVectorAdjointStokes( Vec pg);
		void	  CreatePVectorDiagnosticVert( Vec pg);
		void	  CreatePVectorMelting( Vec pg);
		void	  CreatePVectorPrognostic( Vec pg);
		void	  CreatePVectorSlope( Vec pg);
		void	  CreatePVectorThermal( Vec pg);
		double* GaussFromNode(Node* node);
		void	  GetDofList(int* doflist,int* pnumberofdofs);
		void	  GetDofList1(int* doflist);
		int     GetElementType(void);
		void	  GetNodalFunctions(double* l1l6, double* gauss_coord);
		void	  GetNodalFunctionsDerivatives(double* dh1dh6,double* xyz_list, double* gauss_coord);
		void	  GetNodalFunctionsDerivativesReference(double* dl1dl6,double* gauss_coord);
		void	  GetNodalFunctionsDerivativesReferenceStokes(double* dl1dl7,double* gauss_coord);
		void	  GetNodalFunctionsDerivativesStokes(double* dh1dh7,double* xyz_list, double* gauss_coord);
		void	  GetNodalFunctionsStokes(double* l1l7, double* gauss_coord);
		void    GetParameterValue(double* pvalue,Node* node,int enumtype);
		void    GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_seg,Input* input_in);
		void	  GetPhi(double* phi, double*  epsilon, double viscosity);
		void	  GetSolutionFromInputsDiagnosticHoriz(Vec solutiong);
		void	  GetSolutionFromInputsDiagnosticHutter(Vec solutiong);
		void	  GetSolutionFromInputsDiagnosticStokes(Vec solutiong);
		void	  GetSolutionFromInputsDiagnosticVert(Vec solutiong);
		void	  GetSolutionFromInputsThermal(Vec solutiong);
		void    GetStrainRate3dPattyn(double* epsilon,double* xyz_list, double* gauss, Input* vx_input, Input* vy_input);
		void    GetStrainRate3d(double* epsilon,double* xyz_list, double* gauss, Input* vx_input, Input* vy_input, Input* vz_input);
		Penta*  GetUpperElement(void);
		void	  InputExtrude(int enum_type,int object_type);
		void    InputUpdateFromSolutionAdjointHoriz( double* solutiong);
		void    InputUpdateFromSolutionAdjointStokes( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticHoriz( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticMacAyeal( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticPattyn( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticHutter( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticVert( double* solutiong);
		void    InputUpdateFromSolutionDiagnosticStokes( double* solutiong);
		void    InputUpdateFromSolutionThermal( double* solutiong);
		void    InputUpdateFromSolutionOneDof(double* solutiong,int enum_type);
		void    InputUpdateFromSolutionOneDofCollapsed(double* solutiong,int enum_type);
		bool	  IsInput(int name);
		bool	  IsOnSurface(void);
		void	  ReduceMatrixStokes(double* Ke_reduced, double* Ke_temp);
		void	  ReduceVectorStokes(double* Pe_reduced, double* Ke_temp, double* Pe_temp);
		void	  SetClone(int* minranks);
		Tria*	  SpawnTria(int g0, int g1, int g2);
		void	  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		void	  VecExtrude(Vec vector,double* vector_serial,int iscollapsed);
		/*}}}*/
};
#endif  /* _PENTA_H */
