/*!\file MaxVxx
 */

#include "./MaxVxx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void MaxVxx( double* pmaxvx, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){
	
	int i;
	double maxvx;
	double node_maxvx;
	double element_maxvx;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxVx(&element_maxvx,process_units); //go pick up the minimum velocity in the inputs
	
		if(i==0)maxvx=element_maxvx; //initialize maxvx
		else{
			if(element_maxvx>maxvx)maxvx=element_maxvx;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxvx=-INFINITY;
	}

	#ifdef _PARALLEL_
	/*Figure out minimum across the cluster: */
	MPI_Reduce (&maxvx,&node_maxvx,1,MPI_DOUBLE,MPI_MAX,0,MPI_COMM_WORLD );
	MPI_Bcast(&node_maxvx,1,MPI_DOUBLE,0,MPI_COMM_WORLD);   
	maxvx=node_maxvx;
	#endif

	/*Assign output pointers:*/
	*pmaxvx=maxvx;
}
