/*\file Misfit.c
 *\brief: compute misfit between modeled velocity and observed velocity
 */

#include "./Misfit.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;

	bool process_units=false;

	/* output datasets: */
	double J;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&MisfitUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);

	/*!Call core code: */
	Misfitx(&J, elements,nodes,vertices,loads,materials,parameters,process_units);

	/*write output : */
	WriteData(MISFIT,J);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void MisfitUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [J] = %s(elements,nodes,vertices,loads, materials, parameters);\n",__FUNCT__);
	_printf_("\n");
}
