/*!\file MaxAbsVxx
 */

#include "./MaxAbsVxx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../SurfaceAreax/SurfaceAreax.h"

void MaxAbsVxx( double* pmaxabsvx, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,bool process_units){
	
	int i;
	double maxabsvx;
	double node_maxabsvx;
	double element_maxabsvx;

	/*Go through elements, and request velocity: */
	for(i=0;i<elements->Size();i++){
		Element* element=(Element*)elements->GetObjectByOffset(i);
		element->MaxAbsVx(&element_maxabsvx,process_units); //go pick up the minimum velocity in the inputs
	
		if(i==0)maxabsvx=element_maxabsvx; //initialize maxabsvx
		else{
			if(element_maxabsvx>maxabsvx)maxabsvx=element_maxabsvx;
		}
	}
	/*A safeguard in case: */
	if(elements->Size()==0){
		maxabsvx=-INFINITY;
	}

	#ifdef _PARALLEL_
	/*Figure out minimum across the cluster: */
	MPI_Reduce (&maxabsvx,&node_maxabsvx,1,MPI_DOUBLE,MPI_MIN,0,MPI_COMM_WORLD );
	MPI_Bcast(&node_maxabsvx,1,MPI_DOUBLE,0,MPI_COMM_WORLD);   
	maxabsvx=node_maxabsvx;
	#endif

	/*Assign output pointers:*/
	*pmaxabsvx=maxabsvx;
}
