/*!\file:  NodalValuesUnitConversion.cpp
 * \brief: process nodal_values held in a ElementResult object.
 * For example, velocities need to be in m/yr, melting rates in m/yr, etc ...
 * This centralizes all post-processing of results when they are being output.
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../Container/Container.h"
#include "../../objects/objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"

void NodalValuesUnitConversion(double* nodal_values, int num_nodal_values,int enum_type,Parameters* parameters){

	int i;
	double yts;
	double scale;

	/*Get some values from parameters, that are often needed: */
	parameters->FindParam(&yts,YtsEnum);

	/*Get scaling factor: */
	switch(enum_type){
		case VxEnum:  scale=yts;break; //m/yr
		case VyEnum:  scale=yts;break; //m/yr
		case VzEnum:  scale=yts;break; //m/yr
		case VelEnum: scale=yts;break; //m/yr
		case MeltingRateEnum: scale=yts;break; //m/yr
		case MisfitEnum: scale=pow(yts,2);break; //(m/yr)^2
		case MassFluxEnum: scale=pow(10,-12)*yts;break; // (GigaTon/year)
		default: break;
	}
		
	/*Scale : */
	for(i=0;i<num_nodal_values;i++)nodal_values[i]=nodal_values[i]*scale; 
}
