function J =objectivefunctionC(search_scalar,femmodel,n);
%OBJECTIVEFUNCTIONC - objective function that return a parameter for a certain function

conserve_loads=true;
%recover some parameters
optscal=femmodel.parameters.OptScal(n);
fit=femmodel.parameters.Fit(n);
control_type=femmodel.parameters.ControlType;
control_steady=femmodel.parameters.ControlSteady;
analysis_type=femmodel.parameters.AnalysisType;
isstokes=femmodel.parameters.IsStokes;

%set current configuration
if isstokes,
	femmodel=SetCurrentConfiguration(femmodel,DiagnsoticStokesAnalysisEnum);
else
	femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum);
end

%Use search scalar to shoot parameter in the gradient direction:
[femmodel.elements,femmodel.nodes,femmmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters]=InputControlUpdate(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,search_scalar*optscal,0);

%Run diagnostic with updated inputs:
if(control_steady==0),
	femmodel=solver_diagnostic_nonlinear(femmodel,conserve_loads);  %true means we conserve loads at each diagnostic run
else
	femmodel=diagnostic_core(femmodel);  %We need a 3D velocity!! (vz is required for the next thermal run)
end

%Compute misfit for this velocity field
[femmodel.elements,femmodel.loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices, femmodel.loads,femmodel.materials,femmodel.parameters,fit,FitEnum);
J=CostFunction(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials, femmodel.parameters);
