/*!\file:  objectivefunctionC
 * \brief  objective function that returns a misfit, for a certain parameter.
 */ 

/*include files: {{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../solvers/solvers.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../include/include.h"
/*}}}*/

double objectivefunctionC(double search_scalar,OptArgs* optargs){

	int i;  
	
	/*output: */
	double J;
	
	/*parameters: */
	FemModel* femmodel=NULL;
	int     n;
	double* optscal=NULL;
	double* fit=NULL;
	int     control_type;
	int     analysis_type;
	bool    control_steady;
	bool  isstokes=false;
	bool    conserve_loads=true;
	
	/*Recover finite element model: */
	femmodel=optargs->femmodel;

	/*Recover parameters: */
	n=optargs->n;

	femmodel->parameters->FindParam(&optscal,NULL,OptScalEnum);
	femmodel->parameters->FindParam(&fit,NULL,FitEnum);
	femmodel->parameters->FindParam(&isstokes,IsStokesEnum);
	femmodel->parameters->FindParam(&control_type,ControlTypeEnum);
	femmodel->parameters->FindParam(&control_steady,ControlSteadyEnum);
	femmodel->parameters->FindParam(&analysis_type,AnalysisTypeEnum);

	/*set analysis type to compute velocity: */
	if(isstokes)femmodel->SetCurrentConfiguration(DiagnosticStokesAnalysisEnum);
	else femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum);

	/*update parameter according to scalar: */ //false means: do not copy updated parameter onto ControlParameter input
	InputControlUpdatex(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,search_scalar*optscal[n],false);

	/*Run diagnostic with updated inputs: */
	if(!control_steady) solver_diagnostic_nonlinear(femmodel,conserve_loads);  //true means we conserve loads at each diagnostic run
	else                diagnostic_core(femmodel);	//We need a 3D velocity!! (vz is required for the next thermal run)

	/*Compute misfit for this velocity field.*/
	InputUpdateFromConstantx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,(int)fit[n],FitEnum);
	CostFunctionx( &J, femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials, femmodel->parameters);

	/*Free ressources:*/
	xfree((void**)&fit);
	xfree((void**)&optscal);
	return J;
}
