/*!\file Mergesolutionfromftogx
 * \brief merge solution back from f set into g set
 */

#include "./Mergesolutionfromftogx.h"

void	Mergesolutionfromftogx( Vec* pug, Vec uf, Mat Gmn, Vec ys, NodeSets* nodesets,bool flag_ys0){

	/*output: */
	Vec ug=NULL;
	int  ug_local_size;

	/*intermediary*/
	Vec ys0=NULL;
	Vec u_m=NULL;
	Vec u_n=NULL;
	int u_n_local_size;
	int Gmn_localm,Gmn_localn;
	
	
	/*Merge f set back into n set: */
	u_n=NewVec(nodesets->GetNSize());
	if(uf) VecMerge(u_n,uf,nodesets->GetPV_F(),nodesets->GetFSize());

	/*merge single point constraints into n set: */
	if(ys){
		if (flag_ys0){

			/*Create ys0, full of 0: */
			VecDuplicate(ys,&ys0);
			VecSet(ys0,0.0);
			VecAssemblyBegin(ys0);
			VecAssemblyEnd(ys0);

			VecMerge(u_n,ys0,nodesets->GetPV_S(),nodesets->GetSSize());
		}
		else{
			VecMerge(u_n,ys,nodesets->GetPV_S(),nodesets->GetSSize());
		}
	}

	/* Merge n_set and m_set to g_set:*/
	ug=NewVec(nodesets->GetGSize());
	VecMerge(ug,u_n,nodesets->GetPV_N(),nodesets->GetNSize());

	/*Merge m set into g set: */
	if(nodesets->GetMSize()){
		MatGetLocalSize(Gmn,&Gmn_localm,&Gmn_localn);
		u_m=NewVecFromLocalSize(Gmn_localm);
		MatMultPatch(Gmn,u_n,u_m);
		VecMerge(ug,u_m,nodesets->GetPV_M(),nodesets->GetMSize());
	}
	
		
	/*Free ressources:*/
	VecFree(&ys0);
	VecFree(&u_m);
	VecFree(&u_n);

	/*Assign correct pointer*/
	*pug=ug;
}
