/*!\file DoubleInput.c
 * \brief: implementation of the DoubleInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"

/*DoubleInput constructors and destructor*/
/*FUNCTION DoubleInput::DoubleInput(){{{1*/
DoubleInput::DoubleInput(){
	return;
}
/*}}}*/
/*FUNCTION DoubleInput::DoubleInput(double value){{{1*/
DoubleInput::DoubleInput(int in_enum_type,IssmDouble in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION DoubleInput::~DoubleInput(){{{1*/
DoubleInput::~DoubleInput(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
		/*FUNCTION DoubleInput::Echo {{{1*/
void DoubleInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleInput::DeepEcho{{{1*/
void DoubleInput::DeepEcho(void){

	printf("DoubleInput:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %g\n",this->value);
}
/*}}}*/
/*FUNCTION DoubleInput::Id{{{1*/
int    DoubleInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleInput::MyRank{{{1*/
int    DoubleInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleInput::Marshall{{{1*/
void  DoubleInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleInput: */
	enum_value=DoubleInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleInput::MarshallSize{{{1*/
int   DoubleInput::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleInput::Demarshall{{{1*/
void  DoubleInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DoubleInput::Enum{{{1*/
int DoubleInput::Enum(void){

	return DoubleInputEnum;

}
/*}}}*/
/*FUNCTION DoubleInput::copy{{{1*/
Object* DoubleInput::copy() {
	
	return new DoubleInput(this->enum_type,this->value);

}
/*}}}*/
	
/*DoubleInput management*/
/*FUNCTION DoubleInput::EnumType{{{1*/
int DoubleInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION DoubleInput::SpawnTriaInput{{{1*/
Input* DoubleInput::SpawnTriaInput(int* indices){

	/*output*/
	DoubleInput* outinput=new DoubleInput();

	/*only copy current value*/
	outinput->enum_type=this->enum_type;
	outinput->value=this->value;

	/*Assign output*/
	return outinput;

}
/*}}}*/
/*FUNCTION DoubleInput::SpawnResult{{{1*/
ElementResult* DoubleInput::SpawnResult(int step, double time){

	return new DoubleElementResult(this->enum_type,this->value,step,time);

}
/*}}}*/

/*Object functions*/
/*FUNCTION DoubleInput::GetParameterValue(bool* pvalue) {{{1*/
void DoubleInput::GetParameterValue(bool* pvalue){

	ISSMERROR("cannot return a bool");

}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValue(int* pvalue){{{1*/
void DoubleInput::GetParameterValue(int* pvalue){
#ifdef _SERIAL_
	*pvalue=(int)value;
#else
	ISSMERROR("Double input of enum %i (%s) cannot return an integer",enum_type,EnumAsString(enum_type));
#endif

}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValue(double* pvalue){{{1*/
void DoubleInput::GetParameterValue(double* pvalue){

	/*return value*/
	*pvalue=value;
}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValue(double* pvalue,double* gauss){{{1*/
void DoubleInput::GetParameterValue(double* pvalue,double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValues{{{1*/
void DoubleInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterDerivativeValue{{{1*/
void DoubleInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION DoubleInput::ChangeEnum{{{1*/
void DoubleInput::ChangeEnum(int newenumtype){
	this->enum_type=newenumtype;
}
/*}}}*/
/*FUNCTION DoubleInput::SquareMin{{{1*/
void DoubleInput::SquareMin(double* psquaremin, bool process_units,Parameters* parameters){

	/*square min of a double is the square of the double itself: */
	*psquaremin=pow(value,2);
}
/*}}}*/
/*FUNCTION DoubleInput::Scale{{{1*/
void DoubleInput::Scale(double scale_factor){
	value=value*scale_factor;
}
/*}}}*/
/*FUNCTION DoubleInput::AXPY{{{1*/
void DoubleInput::AXPY(Input* xinput,double scalar){

	DoubleInput*  xdoubleinput=NULL;

	/*xinput is of the same type, so cast it: */
	xdoubleinput=(DoubleInput*)xinput;

	/*Carry out the AXPY operation depending on type:*/
	switch(xinput->Enum()){

		case DoubleInputEnum:
			this->value=this->value+scalar*xdoubleinput->value;
			return;

		default:
			ISSMERROR("not implemented yet");
	}

}
/*}}}*/
/*FUNCTION DoubleInput::Constrain{{{1*/
void DoubleInput::Constrain(double cm_min, double cm_max){

	if(!isnan(cm_min)) if (this->value<cm_min)this->value=cm_min;
	if(!isnan(cm_max)) if (this->value>cm_max)this->value=cm_max;

}
/*}}}*/
/*FUNCTION DoubleInput::GetVectorFromInputs{{{1*/
void DoubleInput::GetVectorFromInputs(Vec vector,int* doflist){

	ISSMERROR(" not supporte yet!");

}
/*}}}*/
/*FUNCTION DoubleInput::GetValuesPtr{{{1*/
void DoubleInput::GetValuesPtr(double** pvalues,int* pnum_values){

	ISSMERROR(" not supported yet!");

}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterAverage{{{1*/
void DoubleInput::GetParameterAverage(double* pvalue){
	*pvalue=value;
}
/*}}}*/
/*FUNCTION DoubleInput::VerticallyIntegrate{{{1*/
void DoubleInput::VerticallyIntegrate(Input* thickness_input){

	/*Intermediaries*/
	double thickness_value;

	/*Check that input provided is a thickness*/
	if (thickness_input->EnumType()!=ThicknessEnum) ISSMERROR("Input provided is not a Thickness (enum_type is %s)",EnumAsString(thickness_input->EnumType()));

	/*vertically integrate depending on type:*/
	switch(thickness_input->Enum()){

		case PentaVertexInputEnum:
			thickness_input->GetParameterAverage(&thickness_value);
			this->value=this->value*thickness_value;
			return;

		default:
			ISSMERROR("not implemented yet");
	}
}
/*}}}*/
/*FUNCTION DoubleInput::PointwiseDivide{{{1*/
Input* DoubleInput::PointwiseDivide(Input* inputB){

	/*Ouput*/
	DoubleInput* outinput=NULL;

	/*Intermediaries*/
	double       AdotBvalue;
	double       Bvalue;

	/*Check that inputB is of the same type*/
	inputB->GetParameterAverage(&Bvalue);

	/*Create new DoubleInput*/
	outinput=new DoubleInput(this->enum_type,this->value/Bvalue);

	/*Return output pointer*/
	return outinput;

}
/*}}}*/
