/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 


#ifndef _ELEMENT_H_
#define _ELEMENT_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"

class DataSet;
class Parameters;
class Patch;

#include "../../toolkits/toolkits.h"
/*}}}*/

class Element: public Object,public Update{

	public: 
		
		virtual        ~Element(){};
	
		virtual void   Configure(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters)=0;
		virtual void   SetCurrentConfiguration(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters)=0;
		virtual void   CreateKMatrix(Mat Kgg)=0;
		virtual void   CreatePVector(Vec pg)=0;
		virtual void   GetSolutionFromInputs(Vec solution)=0;
		virtual void   GetNodes(void** nodes)=0;
		virtual void*  GetMatPar()=0;
		virtual bool   GetShelf()=0; 
		virtual bool   GetOnBed()=0;
		virtual void   GetThicknessList(double* thickness_list)=0;
		virtual void   GetBedList(double* bed_list)=0;
		virtual void   Gradj(Vec gradient,int control_type)=0;
		virtual void   GradjDrag(Vec gradient)=0;
		virtual void   GradjB(Vec gradient)=0;
		virtual double Misfit(void)=0;
		virtual double CostFunction(void)=0;
		virtual double SurfaceArea(void)=0;
		virtual void   InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum)=0;
		virtual void   ComputeBasalStress(Vec sigma_b)=0;
		virtual void   ComputePressure(Vec p_g)=0;
		virtual void   ComputeStrainRate(Vec eps)=0;
		virtual double MassFlux(double* segment)=0;
		virtual void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes)=0;
		virtual void   PatchFill(int* pcount, Patch* patch)=0;
		virtual void   DeleteResults(void)=0;
		virtual void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type)=0;
		virtual void   UpdateGeometry(void)=0;
		virtual void   InputToResult(int enum_type,int step,double time)=0;
		virtual void   MaterialUpdateFromTemperature(void)=0;
		virtual void   ProcessResultsUnits(void)=0;
		virtual void   MinVel(double* pminvel, bool process_units)=0;
		virtual void   MaxVel(double* pmaxvel, bool process_units)=0;
		virtual void   MinVx(double* pminvx, bool process_units)=0;
		virtual void   MaxVx(double* pmaxvx, bool process_units)=0;
		virtual void   MaxAbsVx(double* pmaxabsvx, bool process_units)=0;
		virtual void   MinVy(double* pminvy, bool process_units)=0;
		virtual void   MaxVy(double* pmaxvy, bool process_units)=0;
		virtual void   MaxAbsVy(double* pmaxabsvy, bool process_units)=0;
		virtual void   MinVz(double* pminvz, bool process_units)=0;
		virtual void   MaxVz(double* pmaxvz, bool process_units)=0;
		virtual void   MaxAbsVz(double* pmaxabsvz, bool process_units)=0;
		virtual void   InputDuplicate(int original_enum,int new_enum)=0;
		virtual void   InputScale(int enum_type,double scale_factor)=0;
		virtual void   GetVectorFromInputs(Vec vector,int NameEnum)=0;
		virtual void   InputAXPY(int YEnum, double scalar, int XEnum)=0;
		virtual void   InputControlConstrain(int control_type,double cm_min, double cm_max)=0;
		virtual bool   InputConvergence(double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums)=0;

		/*Implementation: */

};
#endif
