/*!\file:  PentaRef.h
 * \brief abstract class for handling Penta oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 


#ifndef _PENTAREF_H_
#define _PENTAREF_H_

class PentaRef{
	

	public: 
		int* element_type_list; //P1CG, P1DG, MINI, P2...
		int  element_type;
		
		PentaRef();
		PentaRef(const int nummodels);
		~PentaRef();

		/*Management*/
		void SetElementType(int type,int type_counter);

		/*Numerics*/
		void GetNodalFunctionsP1(double* l1l6, double* gauss);
		void GetNodalFunctionsMINI(double* l1l7, double* gauss);
		void GetNodalFunctionsP1Derivatives(double* dh1dh6,double* xyz_list, double* gauss);
		void GetNodalFunctionsMINIDerivatives(double* dh1dh7,double* xyz_list, double* gauss);
		void GetNodalFunctionsP1DerivativesReference(double* dl1dl6,double* gauss);
		void GetNodalFunctionsMINIDerivativesReference(double* dl1dl7,double* gauss);
		void GetJacobian(double* J, double* xyz_list,double* gauss);
		void GetJacobianDeterminant(double*  Jdet, double* xyz_list,double* gauss);
		void GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss);
		void GetBPattyn(double* B, double* xyz_list, double* gauss);
		void GetBprimePattyn(double* B, double* xyz_list, double* gauss);
		void GetBStokes(double* B, double* xyz_list, double* gauss);
		void GetBprimeStokes(double* B_prime, double* xyz_list, double* gauss);
		void GetBprimeVert(double* B, double* xyz_list, double* gauss);
		void GetBAdvec(double* B_advec, double* xyz_list, double* gauss);
		void GetBArtdiff(double* B_artdiff, double* xyz_list, double* gauss);
		void GetBConduct(double* B_conduct, double* xyz_list, double* gauss);
		void GetBVert(double* B, double* xyz_list, double* gauss);
		void GetBprimeAdvec(double* Bprime_advec, double* xyz_list, double* gauss);
		void GetLStokes(double* LStokes, double* gauss_tria);
		void GetLprimeStokes(double* LprimeStokes, double* xyz_list, double* gauss_tria, double* gauss);
		void GetParameterValue(double* pvalue,double* plist,double* gauss);
		void GetParameterDerivativeValue(double* pvalues, double* plist,double* xyz_list, double* gauss);

};
#endif
