/*! \file Beam.h 
 *  \brief: header file for beam object
 */

#ifndef _BEAM_H_
#define _BEAM_H_

/*Headers:*/
/*{{{1*/

#include "./Element.h"
#include "./BeamRef.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;
class Node;
class Matice;
class Matpar;

#include "../../shared/Exceptions/exceptions.h"
#include "../../include/include.h"
/*}}}*/

class Beam: public Element,public BeamRef {

	public:

		/*ids:*/
		int id;

		Node**  nodes; //2 nodes
		Matice* matice;
		Matpar* matpar;
		
		Parameters* parameters; //pointer to solution parameters
		Inputs* inputs;
	

		/*Beam constructors and destructor: {{{1*/
		Beam();
		~Beam();
		/*}}}*/
		/*Object virtual functions definitions: {{{1*/
		Object* copy();
		void    DeepEcho();
		void    Demarshall(char** pmarshalled_dataset);
		void    Echo();
		int     Enum();
		int     Id(); 
		void    Marshall(char** pmarshalled_dataset);
		int     MarshallSize();
		int     MyRank();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromSolution(double* solution);
		/*}}}*/
		/*Element virtual functions definitions: {{{1*/
		void	   ComputeBasalStress(Vec sigma_b);
		void	   ComputePressure(Vec p_g);
		void	   ComputeStrainRate(Vec eps);
		void	   Configure(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		void	   SetCurrentConfiguration(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		double	CostFunction(void);
		void	   CreateKMatrix(Mat Kgg){ISSMERROR("Not implemented yet");};
		void	   CreatePVector(Vec pg);
		void     DeleteResults(void);
		void	   GetBedList(double* bed_list);
		void*	   GetMatPar();
		void	   GetNodes(void** nodes);
		bool	   GetOnBed();
		bool	   GetShelf(); 
		void	   GetSolutionFromInputs(Vec solution);
		void	   GetThicknessList(double* thickness_list);
		void	   GetVectorFromInputs(Vec vector,int NameEnum);
		void	   Gradj(Vec gradient,int control_type);
		void	   GradjB(Vec gradient);
		void	   GradjDrag(Vec gradient);
		void	   InputAXPY(int YEnum, double scalar, int XEnum);
		void	   InputControlConstrain(int control_type,double cm_min, double cm_max);
		bool     InputConvergence(double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums);
		void     InputDepthAverageAtBase(int enum_type,int average_enum_type){ISSMERROR("not implemented yet");}
		void	   InputDuplicate(int original_enum,int new_enum);
		void	   InputScale(int enum_type,double scale_factor);
		void	   InputToResult(int enum_type,int step,double time);
		void	   MaterialUpdateFromTemperature(void){ISSMERROR("not implemented yet");};
		double	MassFlux(double* segment);
		void	   MaxAbsVx(double* pmaxabsvx, bool process_units);
		void	   MaxAbsVy(double* pmaxabsvy, bool process_units);
		void	   MaxAbsVz(double* pmaxabsvz, bool process_units);
		void	   MaxVel(double* pmaxvel, bool process_units);
		void	   MaxVx(double* pmaxvx, bool process_units);
		void	   MaxVy(double* pmaxvy, bool process_units);
		void	   MaxVz(double* pmaxvz, bool process_units);
		void	   MinVel(double* pminvel, bool process_units);
		void	   MinVx(double* pminvx, bool process_units);
		void	   MinVy(double* pminvy, bool process_units);
		void	   MinVz(double* pminvz, bool process_units);
		double	Misfit(void);
		void	   PatchFill(int* pcount, Patch* patch);
		void	   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes);
		void	   ProcessResultsUnits(void);
		double	SurfaceArea(void);
		void     Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type);
		void     UpdateGeometry(void){ISSMERROR("not implemented yet");};
		/*}}}*/
		/*Beam specific routines: {{{1*/
		void	  CreatePVectorDiagnosticHutter(Vec pg);
		void	  GetDofList(int* doflist,int* pnumberofdofs);
		void	  GetDofList1(int* doflist);
		bool	  IsInput(int name);
		void	  SetClone(int* minranks);
		/*}}}*/
};
#endif  /* _BEAM_H */
