/*!\file BeamRef.c
 * \brief: implementation of the BeamRef object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Object constructors and destructor*/
/*FUNCTION BeamRef::BeamRef(){{{1*/
BeamRef::BeamRef(){
	this->element_type_list=NULL;
}
/*}}}*/
/*FUNCTION BeamRef::BeamRef(int* types,int nummodels){{{1*/
BeamRef::BeamRef(const int nummodels){

	/*Only allocate pointer*/
	element_type_list=(int*)xmalloc(nummodels*sizeof(int));

}
/*}}}*/
/*FUNCTION BeamRef::~BeamRef(){{{1*/
BeamRef::~BeamRef(){
	xfree((void**)&element_type_list);
}
/*}}}*/

/*Management*/
/*FUNCTION BeamRef::SetElementType{{{1*/
void BeamRef::SetElementType(int type,int type_counter){

	ISSMASSERT(type==P1Enum || type==P1DGEnum);

	/*initialize element type*/
	this->element_type_list[type_counter]=type;
}
/*}}}*/

/*Reference Element numerics*/
/*FUNCTION BeamRef::GetJacobianDeterminant {{{1*/
void BeamRef::GetJacobianDeterminant(double*  Jdet, double* z_list,double gauss){

	*Jdet=1.0/2.0*(z_list[1]-z_list[0]);
	if(*Jdet<0) ISSMERROR(" negative jacobian determinant!");

}
/*}}}*/
/*FUNCTION BeamRef::GetNodalFunctions {{{1*/
void BeamRef::GetNodalFunctions(double* l1l2, double gauss){
	/*This routine returns the values of the nodal functions  at the gaussian point.*/

	l1l2[0]=-0.5*gauss+0.5;
	l1l2[1]=+0.5*gauss+0.5;

}
/*}}}*/
