/*!\file:  BeamRef.h
 * \brief abstract class for handling Beam oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 


#ifndef _BEAMREF_H_
#define _BEAMREF_H_

class BeamRef{
	

	public: 
		int* element_type_list; //P1CG, P1DG, MINI, P2...
		int  element_type;
		
		BeamRef();
		BeamRef(const int nummodels);
		~BeamRef();

		/*Management*/
		void SetElementType(int type,int type_counter);

		/*Numerics*/
		void GetJacobianDeterminant(double* Jdet, double* z_list,double gauss);
		void GetNodalFunctions(double* l1l2, double gauss);

};
#endif
