function femmodel=balancedthickness_core(femmodel)
%BALANCEDTHICKNESS_CORE - linear solution sequence
%
%   Usage:
%      femmodel=balancedthickness_core(femmode)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	dim=femmodel.parameters.Dim;
	solution_type=femmodel.parameters.SolutionType;

	%Activate formulation
	femmodel=SetCurrentConfiguration(femmodel,BalancedthicknessAnalysisEnum);

	displaystring(verbose,'\n%s',['call computational core...']);
	femmodel=solver_linear(femmodel);

	if solution_type==BalancedthicknessSolutionEnum,
		displaystring(verbose,'\n%s',['saving results...']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,ThicknessEnum);
	end
	
end %end function
