%This test is a test from the ISMP-HOM Intercomparison project
%Pattyn and Payne 2006

%TestD 
L=40000; %in m
nx=45; %numberof nodes in x direction
ny=45;
md=model;
md=squaremesh(md,L,L,nx,ny);
md.z=zeros(md.numberofgrids,1);
md=geography(md,'',''); %ice sheet test
md=parameterize(md,'Square.par');
md=extrude(md,10,1);
md.np=8;
md.cluster='wilkes';

md=setelementstype(md,'pattyn','all');
%md=setelementstype(md,'pattyn','all','stokes','all'); 

%We need one grd on dirichlet: the 4 corners are set to zero
md.spcvelocity=zeros(md.numberofgrids,6);
pos=find((md.x==0 | md.x==max(md.x)) & (md.y==0 | md.y==max(md.y)));
md.spcvelocity(pos,1:3)=1;

%Create MPCs to have periodic boundary conditions
posx=find(md.x==0);
posx2=find(md.x==max(md.x));

posy=find(md.y==0 & md.x~=0 & md.x~=max(md.x)); %Don't take the same grids two times
posy2=find(md.y==max(md.y) & md.x~=0 & md.x~=max(md.x));

md.penalties=[posx,posx2;posy,posy2];

%Compute the diagnostic
md=solve(md,'analysis_type',DiagnosticSolutionEnum);
vx=zeros(md.numberofgrids,1);
vx(md.results.DiagnosticSolution.Vx.index)=md.results.DiagnosticSolution.Vx.value;
vy=zeros(md.numberofgrids,1);
vy(md.results.DiagnosticSolution.Vy.index)=md.results.DiagnosticSolution.Vy.value;
vz=zeros(md.numberofgrids,1);
vz(md.results.DiagnosticSolution.Vz.index)=md.results.DiagnosticSolution.Vz.value;

plotmodel(md,'data',vx,'data',vy,'data',vz,'layer#all',md.numlayers)
