%This test is a test from the ISMP-HOM Intercomparison project
%Pattyn and Payne 2006

%TestA 
L=80000; %in m
nx=20; %numberof nodes in x direction
ny=20;
md=model;
md=squaremesh(md,L,L,nx,ny);
md=geography(md,'',''); %ice sheet test
md=parameterize(md,'Square.par');
md=extrude(md,9,1);
md.verbose=10;
md.np=5;
md.cluster='wilkes';

%md=setelementstype(md,'macayeal','all');
md=setelementstype(md,'pattyn','all');
%md=setelementstype(md,'pattyn','all','stokes','all'); 

%Create dirichlet on the bed only
md.spcvelocity=zeros(md.numberofgrids,6);
pos=find(md.gridonbed);
md.spcvelocity(pos,1:2)=1;

%Create MPCs to have periodic boundary conditions
posx=find(md.x==0);
posx2=find(md.x==max(md.x));

posy=find(md.y==0 & md.x~=0 & md.x~=max(md.x)); %Don't take the same grids two times
posy2=find(md.y==max(md.y) & md.x~=0 & md.x~=max(md.x));

md.penalties=[posx,posx2;posy,posy2];

%Compute the diagnostic
md=solve(md,'analysis_type',DiagnosticSolutionEnum);
vx=zeros(md.numberofgrids,1);
vx(md.results.DiagnosticSolution.Vx.index)=md.results.DiagnosticSolution.Vx.value;
vy=zeros(md.numberofgrids,1);
vy(md.results.DiagnosticSolution.Vy.index)=md.results.DiagnosticSolution.Vy.value;
vz=zeros(md.numberofgrids,1);
vz(md.results.DiagnosticSolution.Vz.index)=md.results.DiagnosticSolution.Vz.value;

plotmodel(md,'data',vx,'data',vy,'data',vz,'layer#all',md.numlayers,'contourlevels',{9.2,18.4,27.6,46,73.6,82.8},'contourlevels',{0,-1.2,-0.9,-0.6,-0.3,1.2},'contourlevels',{-5.2,-3.9,-1.3,0,1.3,3.9,5.2})
