/*!\file Penpair.h
 * \brief: header file for penpair object */

#ifndef _PENPAIR_H_
#define _PENPAIR_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
#include "../Node.h"
#include "../Elements/Element.h"

class Element;
/*}}}*/

class Penpair: public Load{

	private: 
		int		id;
		int analysis_type;
		
		Hook* hnodes;  //hook to 2 nodes

		Parameters* parameters; //pointer to solution parameters

	public:

		/*Penpair constructors, destructors: {{{1*/
		Penpair();
		Penpair(int penpair_id,int* penpair_node_ids,int analysis_type);
		~Penpair();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void  InputUpdateFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		/*}}}*/
			/*Load virtual functions definitions: {{{1*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax);
		void  PenaltyCreatePVector(Vec pg,double kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
			/*Penpair management: {{{1*/
		void  PenaltyCreateKMatrixDiagnosticHoriz(Mat Kgg,double kmax);
		void  GetDofList(int* doflist,int* pnumberofdofspernode);
		/*}}}*/
};

#endif  /* _PENPAIR_H_ */


