function md=roundmesh(md,radius,resolution)
%ROUNDMESH - create an unstructured round mesh 
%
%   This script will generate a structured round mesh
%   - radius     : specifies the radius of the circle in meters
%   - resolution : specifies the resolution in meters
%
%   Usage:
%      md=roundmesh(md,radius,resolution)

%First we have to create the domain outline 

%Get number of points on the circle
pointsonedge=floor((2*pi*radius) / resolution);

%Calculate the cartesians coordinates of the points
x_list=ones(pointsonedge,1); y_list=ones(pointsonedge,1);
theta=(0:2*pi/pointsonedge:2*pi*(1-1/pointsonedge))';
x_list=radius*x_list.*cos(theta);
y_list=radius*y_list.*sin(theta);
A=struct('x',x_list,'y',y_list,'density',1);
expgen('RoundDomainOutline.exp',A,1);

%Call Bamg
md=mesh(md,'RoundDomainOutline.exp',resolution);
%md=bamg(md,'domain','RoundDomainOutline.exp','hmin',resolution);

%move the closest node to the center
[mini pos]=min(md.x.^2+md.y.^2);
md.x(pos)=0;
md.y(pos)=0;
