function updatearchive(varargin)
% This file can be run to update the velocity archives  of the test1.
% This test deals with an icesheet without icefront for a 2d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

% The archive files will be saved in this directory but will not commited to ice1. 
% Just commit the result if you want to.

%packages and analysis_types to be tested
if nargin==1,
	packages=varargin{1};
else
	packages={'macayeal','ice','cielo_serial','cielo_parallel'};
end
solutions={'diagnostic','prognostic'};

%go through the solutions requested
testname='IceSheetNoIceFrontM2d_16';
for i=1:length(packages),
	package=packages{i};

	for j=1:length(solutions),
		solution=solutions{j};

		%check solution requested
		if (~strcmpi(package,'ice') & strcmpi(solution,'prognostic')),
			disp(sprintf(['\nsolution: ' solution  ', with package: ' package  ', in test: ' testname  ', not supported yet.\n']));
			continue
		end

		%initialize model
		md=model;
		md=mesh(md,'DomainOutline.exp',50000);
		md=geography(md,'','');
		md=parameterize(md,'Square.par');
		md=setelementstype(md,'macayeal','all');
		if strcmpi(package,'cielo_parallel'), md.cluster='wilkes'; end
		if md.numberofgrids==388
			load Velocities; md.vx=0.5*vx; md.vy=0.5*vy;
		end

		%compute solution
		if (strcmpi(package,'cielo_serial') | strcmpi(package,'cielo_parallel')),
			md=solve(md,'analysis_type',solution,'package','cielo');
		else
			md=solve(md,'analysis_type',solution,'package',package);
		end

		%field to be saved
		if strcmpi(solution,'diagnostic'),
			fields={'vel'};
		elseif strcmpi(solution,'prognostic'),
			fields={'new_thickness'};
		end

		%save new archive
		for k=1:length(fields),
			field=fields{k};
			eval(['Archive' package solution '_field' num2str(k) '=md.' field  ';']);
		end
		eval(['save Archive' package solution ' Archive' package solution '_field*']);
	end
end
