/*!\file InputConvergencex
 */

#include "./InputConvergencex.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

bool InputConvergencex(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters,int* enums, int num_enums, int* criterionenums, double* criterionvalues,int num_criterionenums){

	/*intermediary:*/
	int         i;
	bool        converged;
	int         num_notconverged=0;
	int         total_notconverged;
	double     *eps       = NULL;
	Element*    element=NULL;
	int         verbose;

	/*retrieve parameters: */
	parameters->FindParam(&verbose,VerboseEnum);
	
	/*allocate dynamic memory: */
	eps=(double*)xmalloc(num_criterionenums*sizeof(double));

	/*Go through elements, and ask them to do the job: */
	for(i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		converged=element->InputConvergence(eps,enums,num_enums,criterionenums,criterionvalues,num_criterionenums);
		if(!converged) num_notconverged++;
	}

	/*In parallel, we need to gather the converged status: */
	#ifdef _PARALLEL_
	MPI_Allreduce ( (void*)&num_notconverged,(void*)&total_notconverged,1,MPI_INT,MPI_SUM,MPI_COMM_WORLD);
	#endif
	_printf_("      #elements above convergence criterion = %i\n",total_notconverged);

	/*Free ressources:*/
	xfree((void**)&eps);

	/*return: */
	if (total_notconverged){
		return false;}
	else{
		return true;}
}
