% This file can be run to compare MacAyeal and Pattyn's model ie a 2d and a 3d model.
% This test deals with a  mesh includind an iceshelf ans an icesheet. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

%Compute solution for a Pattyn model
md=model;
md=mesh(md,'DomainOutline.exp',50000);
md=geography(md,'Shelf.exp','');
md=parameterize(md,'Square.par');
md=extrude(md,5,3);
md=setelementstype(md,'Pattyn','all');

md=solve(md,'analysis_type',DiagnosticSolutionEnum);
vel_pattyn=zeros(md.numberofgrids,1);
vel_pattyn(md.results.DiagnosticSolution.Vel.index)=md.results.DiagnosticSolution.Vel.value;
vx_pattyn=zeros(md.numberofgrids,1);
vx_pattyn(md.results.DiagnosticSolution.Vx.index)=md.results.DiagnosticSolution.Vx.value;
vy_pattyn=zeros(md.numberofgrids,1);
vy_pattyn(md.results.DiagnosticSolution.Vy.index)=md.results.DiagnosticSolution.Vy.value;
vz_pattyn=zeros(md.numberofgrids,1);
vz_pattyn(md.results.DiagnosticSolution.Vz.index)=md.results.DiagnosticSolution.Vz.value;
pressure_pattyn=zeros(md.numberofgrids,1);
pressure_pattyn(md.results.DiagnosticSolution.Pressure.index)=md.results.DiagnosticSolution.Pressure.value;

mdpattyn=md;
save modelpattyn mdpattyn;

%Compute solution for a Stokes model
md=model;
md=mesh(md,'DomainOutline.exp',50000);
md=geography(md,'Shelf.exp','');
md=parameterize(md,'Square.par');
md=extrude(md,5,3);
md=setelementstype(md,'Pattyn','all','Stokes','all');

md=solve(md,'analysis_type',DiagnosticSolutionEnum);
vel_stokes=zeros(md.numberofgrids,1);
vel_stokes(md.results.DiagnosticSolution.Vel.index)=md.results.DiagnosticSolution.Vel.value;
vx_stokes=zeros(md.numberofgrids,1);
vx_stokes(md.results.DiagnosticSolution.Vx.index)=md.results.DiagnosticSolution.Vx.value;
vy_stokes=zeros(md.numberofgrids,1);
vy_stokes(md.results.DiagnosticSolution.Vy.index)=md.results.DiagnosticSolution.Vy.value;
vz_stokes=zeros(md.numberofgrids,1);
vz_stokes(md.results.DiagnosticSolution.Vz.index)=md.results.DiagnosticSolution.Vz.value;
pressure_stokes=zeros(md.numberofgrids,1);
pressure_stokes(md.results.DiagnosticSolution.Pressure.index)=md.results.DiagnosticSolution.Pressure.value;

mdstokes=md;
save modelstokes mdstokes;

%plot the two velocities
plotmodel(md,'data',vel_pattyn,'data',vel_stokes,'data',abs((vel_pattyn-vel_stokes)./vel_pattyn)*100,'data',vel_pattyn-vel_stokes,'title','Pattyn velocity','title','Stokes velocity','title','Relative difference','title','Absolute difference','view#all',2)
