/*!\file:  OutputResultsx.h
 * \brief header file for outputing results
 */ 

#ifndef _OUTPUTRESULTSX_H
#define _OUTPUTRESULTSX_H

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../Container/Container.h"

#ifdef _SERIAL_
#include <mex.h>
void OutputResultsx(mxArray** pdataref, Elements* elements, Nodes* nodes, Vertices* vertices, Loads* loads,  Materials* materials, Parameters* parameters,DataSet** results,int step=0,double time=0);
void MatlabWriteResults(mxArray** pdataref, Parameters* parameters, DataSet* results);
#else
void OutputResultsx(Elements* elements, Nodes* nodes, Vertices* vertices, Loads* loads,  Materials* materials, Parameters* parameters,DataSet** results,int step=0,double time=0);
void FileWriteResults(Parameters* parameters, DataSet* results);
#endif

/* local prototypes: */
void ElementResultsToPatch(Elements* elements,  Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials, Parameters* parameters,DataSet* results,int step, double time);

#endif  /* _OUTPUTRESULTS_H */

