/*!\file: FileWriteResults.cpp
 * \brief: write results in femmodel->results to disk
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../io/io.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"

void FileWriteResults(Parameters* parameters, DataSet* results){

	int         i;
	extern int  my_rank;
	FILE       *fid          = NULL;

	//Recover file name: 
	parameters->FindParam(&fid,OutputFilePointerEnum);

	for(i=0;i<results->Size();i++){
		ExternalResult* result=(ExternalResult*)results->GetObjectByOffset(i);

		/*write result to disk: */
		result->WriteData(fid);
	}
}
