/*! \file DoubleParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _DOUBLEPARAM_H_
#define _DOUBLEPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class DoubleParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		IssmDouble value;

	public:
		/*DoubleParam constructors, destructors: {{{1*/
		DoubleParam();
		DoubleParam(int enum_type,IssmDouble value);
		~DoubleParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool);
		void  GetParameterValue(int* pinteger);
		void  GetParameterValue(double* pdouble){*pdouble=value;}
		void  GetParameterValue(char** pstring){ISSMERROR("Double param of enum %i (%s) cannot return a string",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("Double param of enum %i (%s) cannot return a string arrayl",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("Double param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("Double param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double*** parray, int* pM,int** pmdims, int** pndims){ISSMERROR("Double param of enum %i (%s) cannot return a matrix array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Vec* pvec){ISSMERROR("Double param of enum %i (%s) cannot return a Vec",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Mat* pmat){ISSMERROR("Double param of enum %i (%s) cannot return a Mat",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(FILE** pfid){ISSMERROR("Double param of enum %i (%s) cannot return a FILE",enum_type,EnumAsString(enum_type));}

		void  SetValue(bool boolean){this->value=(double)boolean;}
		void  SetValue(int integer){this->value=(double)integer;}
		void  SetValue(double scalar){this->value=(double)scalar;}
		void  SetValue(char* string){ISSMERROR("Double param of enum %i (%s) cannot hold a string",enum_type,EnumAsString(enum_type));}
		void  SetValue(char** stringarray,int M){ISSMERROR("Double param of enum %i (%s) cannot hold a string array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* doublearray,int M){ISSMERROR("Double param of enum %i (%s) cannot hold a double array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){ISSMERROR("Double param of enum %i (%s) cannot hold a double array",enum_type,EnumAsString(enum_type));}
		void  SetValue(Vec vec){ISSMERROR("Double param of enum %i (%s) cannot hold a Vec",enum_type,EnumAsString(enum_type));}
		void  SetValue(Mat mat){ISSMERROR("Double param of enum %i (%s) cannot hold a Mat",enum_type,EnumAsString(enum_type));}
		void  SetValue(FILE* fid){ISSMERROR("Double param of enum %i (%s) cannot hold a FILE",enum_type,EnumAsString(enum_type));}
		void  SetValue(double** array, int M, int* mdim_array, int* ndim_array){ISSMERROR("Double param of enum %i (%s) cannot hold an array of matrices",enum_type,EnumAsString(enum_type));}

		char* GetParameterName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _DOUBLEPARAM_H */
