%Test on the diagnostic model and the prognostic in 2d

%Evolution of the ice shelf
md=model;
md=mesh(md,'DomainOutline.exp',5100);
md=geography(md,'all','');
md=parameterize(md,'Square.par');
md=setelementstype(md,'macayeal','all'); %MacAyeal's model and 2d

md.np=5;
md.cluster='wilkes';
md.verbose=3;
%Compute solution for MacAyeal's model 
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%Launch transient solution
vx=zeros(md.numberofgrids,1);
vx(md.results.DiagnosticSolution.Vx.index)=md.results.DiagnosticSolution.Vx.value;
vy=zeros(md.numberofgrids,1);
vy(md.results.DiagnosticSolution.Vy.index)=md.results.DiagnosticSolution.Vy.value;
md.vx=vx;
md.vy=vy;

md.ndt=1000*md.yts; %time of evolution
md.dt=20*md.yts; %time vetween two iterations
md=solve(md,'analysis_type',Transient2DSolutionEnum);

%plot results
plotmodel(md,'data',md.results.Transient2DSolution(end).Vx,'data',md.results.Transient2DSolution(end).Vy,'data',md.results.Transient2DSolution(end).Thickness)
