%Test on the diagnostic model and the prognostic in 2d

%test 5 and 6 : 
md=model;
md=mesh(md,'DomainOutline.exp',5100); %test3
%md=mesh(md,'DomainOutline.exp',3550); %test4
md=geography(md,'all','');
md=parameterize(md,'Square.par');
md=setelementstype(md,'macayeal','all'); %MacAyeal's model and 2d
md.verbose=10;

%Compute solution for MacAyeal's model 
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%plot results
vx=zeros(md.numberofgrids,1);
vx(md.results.DiagnosticSolution.Vx.index)=md.results.DiagnosticSolution.Vu.value;
vy=zeros(md.numberofgrids,1);
vy(md.results.DiagnosticSolution.Vy.index)=md.results.DiagnosticSolution.Vy.value;
plotmodel(md,'data',vx,'data',vy,'contourlevels',{0,20,40,-20,-40,-60,60},'contourlevels',{-100,-200,-300,-400,-500,-600,-700,-800})
