/*!\file DakotaResponsesx
 * \brief: update datasets using  parameter inputs
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./DakotaResponsesx.h"
#include "../../Container/Container.h"    
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../toolkits/toolkits.h"
#include "../modules.h"


void DakotaResponsesx(double* responses,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters,char** responses_descriptors,int numresponses){

	int        i,j;
	int        dummy;
	int        counter;
	extern int my_rank;

	/*intermediary: */
	char* response_descriptor=NULL;
	double femmodel_response;
			
	for(i=0;i<numresponses;i++){

		response_descriptor=responses_descriptors[i];

		/*Compute response for this response_descriptor:*/

		if(strcmp(response_descriptor,"MinVel")==0){
			MinVelx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"MaxVel")==0){
			MaxVelx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"MinVx")==0){
			MinVxx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"MaxVx")==0){
			MaxVxx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"MaxAbsVx")==0){
			MaxAbsVxx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"MinVy")==0){
			MinVyx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"MaxVy")==0){
			MaxVyx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"MaxAbsVy")==0){
			MaxAbsVyx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"MinVz")==0){
			MinVzx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"MaxVz")==0){
			MaxVzx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"MaxAbsVz")==0){
			MaxAbsVzx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strcmp(response_descriptor,"Misfit")==0){
			Misfitx( &femmodel_response, elements,nodes, vertices, loads, materials, parameters);
		}
		else if(strlen(response_descriptor)>=8){
			if(strncmp(response_descriptor,"MassFlux",8)==0){

				/*Deal with several mass flux computations: {{{1*/
				double** array=NULL;
				int      M;
				int*     mdims_array=NULL;
				int*     ndims_array=NULL;

				double*  segments=NULL;
				int      num_segments;

				/*retrieve qmu_mass_flux_segments: */
				parameters->FindParam(&array,&M,&mdims_array,&ndims_array,QmuMassFluxSegmentsEnum);

				/*figure out counter after MassFlux: */
				sscanf(response_descriptor,"MassFlux%i",&counter);

				/*retrieve segments from array: */
				segments=array[counter-1]; //matlab to "C" indexing
				num_segments=mdims_array[counter-1];

				/*call mass flux module: */
				MassFluxx(&femmodel_response,elements,nodes,vertices,loads,materials,parameters,segments,num_segments);

				/*Free ressources:*/
				for(j=0;j<M;j++){
					double* matrix=array[j];
					xfree((void**)&matrix);
				}
				xfree((void**)&mdims_array);
				xfree((void**)&ndims_array);
				xfree((void**)&array);
				/*}}}*/
			}
		}
		else{
			ISSMERROR("%s%s%s"," response descriptor : ",response_descriptor," not supported yet!");
		}

		#ifdef _DEBUG_
		if(my_rank==0)printf("response: %s: %g\n",response_descriptor,femmodel_response);
		#endif
			
		/*send response back to Dakota only on cpu 0: */
		if(my_rank==0)responses[i]=femmodel_response;
	}

}
