/*! \file PetscMatParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _PETSCMATPARAM_H_
#define _PETSCMATPARAM_H_

/*Headers:*/
/*{{{1*/

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif


#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../include/include.h"
/*}}}*/

class PetscMatParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		Mat value;

	public:
		/*PetscMatParam constructors, destructors: {{{1*/
		PetscMatParam();
		PetscMatParam(int enum_type,Mat value);
		~PetscMatParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{1*/
		int   EnumType(){return enum_type;}
		void  GetParameterValue(bool* pbool){ISSMERROR("PetscMat param of enum %i (%s) cannot return a bool",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(int* pinteger){ISSMERROR("PetscMat param of enum %i (%s) cannot return an integer",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double* pdouble){ISSMERROR("PetscMat param of enum %i (%s) cannot return a double",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char** pstring){ISSMERROR("PetscMat param of enum %i (%s) cannot return a string",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){ISSMERROR("PetscMat param of enum %i (%s) cannot return a string arrayl",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){ISSMERROR("PetscMat param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){ISSMERROR("PetscMat param of enum %i (%s) cannot return a double array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(double*** parray, int* pM,int** pmdims, int** pndims){ISSMERROR("PetscMat param of enum %i (%s) cannot return a matrix array",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Vec* pvec){ISSMERROR("PetscMat param of enum %i (%s) cannot return a vec",enum_type,EnumAsString(enum_type));}
		void  GetParameterValue(Mat* poutput);

		void  SetValue(bool boolean){ISSMERROR("PetscMat param of enum %i (%s) cannot hold a boolean",enum_type,EnumAsString(enum_type));}
		void  SetValue(int integer){ISSMERROR("PetscMat param of enum %i (%s) cannot hold an integer",enum_type,EnumAsString(enum_type));}
		void  SetValue(double scalar){ISSMERROR("PetscMat param of enum %i (%s) cannot hold a scalar",enum_type,EnumAsString(enum_type));}
		void  SetValue(char* string){ISSMERROR("PetscMat param of enum %i (%s) cannot hold a string",enum_type,EnumAsString(enum_type));}
		void  SetValue(char** stringarray,int M){ISSMERROR("PetscMat param of enum %i (%s) cannot hold a string array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* doublearray,int M){ISSMERROR("PetscMat param of enum %i (%s) cannot hold a double array",enum_type,EnumAsString(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){ISSMERROR("PetscMat param of enum %i (%s) cannot hold a double array",enum_type,EnumAsString(enum_type));}
		void  SetValue(Vec vec){ISSMERROR("PetscMat param of enum %i (%s) cannot hold a Vec",enum_type,EnumAsString(enum_type));}
		void  SetValue(Mat mat);
		void  SetValue(double** array, int M, int* mdim_array, int* ndim_array){ISSMERROR("PetscMat param of enum %i (%s) cannot hold an array of matrices",enum_type,EnumAsString(enum_type));}

		char* GetParameterName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _PETSCMATPARAM_H */
