step=[1 2];
division=2;
density=70000;
startup

%step1: initial velocity -> observed velocity
if ismember(1,step),
	disp(sprintf('\nSTEP 1 : Build observed velocity\n'));

	%create model
	md=model;
	md=mesh(md,'DomainOutline.exp',density);
	md=geography(md,'','');
	md=parameterize(md,'Squaredrag.par');
	md=setelementstype(md,'macayeal','all');

	%tweak drag
	maxx=max(md.x); minx=min(md.x); Lx=maxx-minx;
	maxy=max(md.y); miny=min(md.y); Ly=maxy-miny;
	drag=linspace(10,50,division^2);
	drag=drag(randperm(division^2));
	count=1;
	for i=1:division
		for j=1:division
			md.drag_coefficient(find(md.x>=(minx+(i-1)*Lx/division) & md.x<=(minx+i*Lx/division) & md.y>=(miny+(j-1)*Ly/division) & md.y<=(miny+j*Ly/division)))=drag(count);
			count=count+1;
		end
	end

	%diagnostic with this drag
	md=solve(md,'analysis_type',DiagnosticSolutionEnum);

	%save observed velocities and exact B
	vx_obs=zeros(md.numberofgrids,1);
	vx_obs(md.results.DiagnosticSolution.Vx.index)=md.results.DiagnosticSolution.Vx.value;
	vy_obs=zeros(md.numberofgrids,1);
	vy_obs(md.results.DiagnosticSolution.Vy.index)=md.results.DiagnosticSolution.Vy.value;
	drag=md.drag_coefficient;
	save ObservedVelocities vx_obs vy_obs
	save Exactdrag drag
	clear md
end

%step2: control method
if ismember(2,step),
	disp(sprintf('\nSTEP 2 : control method\n'));

	%create model
	md=model;
	md=mesh(md,'DomainOutline.exp',density);
	md=geography(md,'','');
	md=parameterize(md,'Squaredrag.par');
	md=setelementstype(md,'macayeal','all');

	%plug computed velocities
	load ObservedVelocities
	md.vx_obs=vx_obs; md.vy_obs=vy_obs;

	%control method
	md.nsteps=10;
	md.control_type='drag_coefficient';
	md.cm_min=0;
	md.cm_max=100;
	md.cm_jump=0.99*ones(md.nsteps,1);
	md.plot=1;
	md.verbose=0;
	md.weights=1*ones(md.numberofgrids,1);
	md.optscal=180*ones(md.nsteps,1);
	md.fit=2*ones(md.nsteps,1);
	md.maxiter=10*ones(md.nsteps,1);
	md.eps_rel=0.001;
	md.eps_abs=NaN;

%md.cluster='wilkes';
md.control_analysis=1;
md=solve(md,'analysis_type',DiagnosticSolutionEnum);
end
