/*
 * CreateConstraintsThermal.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateConstraintsThermal"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"


void	CreateConstraintsThermal(DataSet** pconstraints, Model* model,ConstDataHandle model_handle){


	int i;
	int count;
	
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;

	/*spc intermediary data: */
	int spc_sid;
	int spc_node;
	int spc_dof;
	double spc_value;
	
	double* dirichletvalues_thermal=NULL;
	double* gridondirichlet_thermal=NULL;
	
	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Fetch data: */
	ModelFetchData((void**)&gridondirichlet_thermal,NULL,NULL,model_handle,"gridondirichlet_thermal","Matrix","Mat");
	ModelFetchData((void**)&dirichletvalues_thermal,NULL,NULL,model_handle,"dirichletvalues_thermal","Matrix","Mat");

	count=0;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<model->numberofnodes;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if((model->my_grids[i]==1)){
	#endif

		if ((int)gridondirichlet_thermal[i]){
	
			/*This grid needs to be spc'd to vx_obs and vy_obs:*/

			spc_sid=count;
			spc_node=i+1;
			spc_dof=1; //we enforce first translation degree of freedom, for temperature
			spc_value=dirichletvalues_thermal[i];

			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;
		}

	#ifdef _PARALLEL_
	} //if((my_grids[i]==1))
	#endif
	}

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	
	cleanup_and_return:
	/*Free data: */
	xfree((void**)&gridondirichlet_thermal);
	xfree((void**)&dirichletvalues_thermal);
	
	/*Assign output pointer: */
	*pconstraints=constraints;
}
