/*! \file CreateLoadsMelting.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateLoadsMelting"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../Model.h"


void	CreateLoadsMelting(DataSet** ploads, Model* model,ConstDataHandle model_handle){

	int i,j,counter;
	int element;

	extern int my_rank;
	extern int num_procs;
	
	DataSet*    loads    = NULL;
	Pengrid*    pengrid  = NULL;

	int segment_width;
	int i1,i2,i3,i4;
	int i0,range;
	int grid1,grid2;

	/*pengrid intermediary data: */
	int pengrid_id;
	int pengrid_node_id;
	int pengrid_mparid;
	int pengrid_dof;
	double pengrid_penalty_offset;
	int pengrid_active=0;
	int pengrid_thermal_steadystate=1;

	int count;

	/*Create loads: */
	loads   = new DataSet(LoadsEnum());
	count=0;

	//create penalties for grids: no grid can have a temperature over the melting point
	ModelFetchData((void**)&model->gridonbed,NULL,NULL,model_handle,"gridonbed","Matrix","Mat");

	for (i=0;i<model->numberofnodes;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if((model->my_grids[i]==1)){
	#endif

		if (model->gridonbed[i]){ 
		
			pengrid_id=count+1; //matlab indexing
			pengrid_node_id=i+1;
			pengrid_dof=1;
			pengrid_penalty_offset=model->penalty_offset;
			pengrid_active=0;
			pengrid_mparid=model->numberofelements+1;//refers to the corresponding parmat property card
			
			pengrid= new Pengrid(pengrid_id, pengrid_node_id,pengrid_mparid,pengrid_dof, pengrid_active, pengrid_penalty_offset,pengrid_thermal_steadystate);
			
			loads->AddObject(pengrid);
			count++;
		}
	#ifdef _PARALLEL_
	} //if((model->my_grids[i]==1))
	#endif
	}
	xfree((void**)&model->gridonbed);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*ploads=loads;

}


