/*! \file CreateLoadsDiagnosticStokes.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateLoadsDiagnosticStokes"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../Model.h"


void	CreateLoadsDiagnosticStokes(DataSet** ploads, Model* model,ConstDataHandle model_handle){

	int i,j,counter;
	int element;

	extern int my_rank;
	extern int num_procs;
	
	DataSet*    loads    = NULL;
	Icefront*   icefront = NULL;
	Pengrid*    pengrid  = NULL;

	int segment_width;
	int i1,i2,i3,i4;
	int i0,range;
	int grid1,grid2;

	/*icefront intermediary data: */
	char icefront_type[ICEFRONTSTRING];
	int icefront_element_type;
	int	icefront_sid;
	int icefront_eid;
	int icefront_mparid;
	int	icefront_node_ids[MAX_ICEFRONT_GRIDS];
	double icefront_h[MAX_ICEFRONT_GRIDS];
	double	icefront_b[MAX_ICEFRONT_GRIDS];

	/*pengrid intermediary data: */
	int pengrid_id;
	int pengrid_mparid;
	int pengrid_node_id;
	int pengrid_dof;
	double pengrid_penalty_offset;
	int pengrid_active=0;
	int pengrid_thermal_steadystate=1;

	int numberofsegs_diag_stokes;
	int count;


	/*Create loads: */
	loads   = new DataSet(LoadsEnum());

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!model->isstokes)goto cleanup_and_return;

	/*Create pressure loads as boundary conditions. Pay attention to the partitioning if we are running in parallel (the grids
	 * referenced by a certain load must belong to the cluster node): */
	ModelFetchData((void**)&model->segmentonneumann_diag_stokes,&numberofsegs_diag_stokes,NULL,model_handle,"segmentonneumann_diag_stokes","Matrix","Mat");
	ModelFetchData((void**)&model->elements_type,NULL,NULL,model_handle,"elements_type","Matrix","Mat");
	ModelFetchData((void**)&model->thickness,NULL,NULL,model_handle,"thickness","Matrix","Mat");
	ModelFetchData((void**)&model->bed,NULL,NULL,model_handle,"bed","Matrix","Mat");

	count=0;

	/*First load data:*/
	for (i=0;i<numberofsegs_diag_stokes;i++){
		
		segment_width=5;

		element=(int)(*(model->segmentonneumann_diag_stokes+segment_width*i+segment_width-1)-1); //element is in the last column

		#ifdef _PARALLEL_
		if (model->epart[element]!=my_rank){
			/*This load does not belong to this cluster node, as it references an element 
			 *that does not belong to this node's partition. Drop this 'i':*/
			continue;
		}
		#endif
	
		icefront_mparid=model->numberofelements+1; //matlab indexing
		icefront_sid=count+1; //matlab indexing
		icefront_eid=(int)*(model->segmentonneumann_diag_stokes+segment_width*i+segment_width-1); //matlab indexing
		icefront_element_type=PentaEnum();

		i1=(int)*(model->segmentonneumann_diag_stokes+segment_width*i+0);
		i2=(int)*(model->segmentonneumann_diag_stokes+segment_width*i+1);
		i3=(int)*(model->segmentonneumann_diag_stokes+segment_width*i+2);
		i4=(int)*(model->segmentonneumann_diag_stokes+segment_width*i+3);
	
		icefront_node_ids[0]=i1;
		icefront_node_ids[1]=i2;
		icefront_node_ids[2]=i3;
		icefront_node_ids[3]=i4;
	
		icefront_h[0]=model->thickness[i1-1];
		icefront_h[1]=model->thickness[i2-1];
		icefront_h[2]=model->thickness[i3-1];
		icefront_h[3]=model->thickness[i4-1];

		icefront_b[0]=model->bed[i1-1];
		icefront_b[1]=model->bed[i2-1];
		icefront_b[2]=model->bed[i3-1];
		icefront_b[3]=model->bed[i4-1];
	
		icefront = new Icefront(icefront_type,icefront_sid,icefront_mparid,icefront_eid,icefront_element_type,icefront_node_ids,icefront_h,icefront_b);
		
		loads->AddObject(icefront);
		count++;

	}
	/*Free data: */
	xfree((void**)&model->segmentonneumann_diag_stokes);
	xfree((void**)&model->elements_type);
	xfree((void**)&model->thickness);
	xfree((void**)&model->bed);




	//create penalties for grids on the base of icesheet. We must have wb=ub*db/dx+vb*db/dy

	ModelFetchData((void**)&model->gridonbed,NULL,NULL,model_handle,"gridonbed","Matrix","Mat");
	ModelFetchData((void**)&model->gridonicesheet,NULL,NULL,model_handle,"gridonicesheet","Matrix","Mat");
	ModelFetchData((void**)&model->gridonstokes,NULL,NULL,model_handle,"gridonstokes","Matrix","Mat");
	
	for (i=0;i<model->numberofnodes;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if((model->my_grids[i]==1)){
	#endif

		if ((model->gridonbed[i]) && (model->gridonicesheet[i]) && (model->gridonstokes[i])){

			pengrid_id=count+1; //matlab indexing
			pengrid_node_id=i+1;
			pengrid_dof=1;
			pengrid_penalty_offset=model->penalty_offset;
			pengrid_mparid=model->numberofelements+1;//refers to the corresponding parmat property card

			pengrid= new Pengrid(pengrid_id, pengrid_node_id,pengrid_mparid,pengrid_dof, pengrid_active, pengrid_penalty_offset,pengrid_thermal_steadystate);
			
			loads->AddObject(pengrid);
			count++;
		}
	#ifdef _PARALLEL_
	} //if((model->my_grids[i]==1))
	#endif
	}



	xfree((void**)&model->gridonbed);
	xfree((void**)&model->gridonstokes);
	xfree((void**)&model->gridonicesheet);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*ploads=loads;

}


