function femmodel=solver_thermal_nonlinear(femmodel)
%SOLVER_THERMAL_NONLINEAR - core of thermal solution sequence.
%   femmodel is returned together with temperature and melting_offset, in case loads have been modified
%
%   Usage:
%      [femmodel]=solver_thermal_nonlinear(femmodel)

	count=1;
	converged=0;

	%stiffness and load generation only:
	femmodel.parameters.Kflag=1; femmodel.parameters.Pflag=1;

	displaystring(femmodel.parameters.Verbose,'\n%s',['   starting direct shooting method']);
	while(~converged),

		%Update inputs in datasets
		if count==1 reset_penalties=0; else reset_penalties=1; end
		[femmodel.elements femmodel.loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,reset_penalties,ResetPenaltiesEnum);

		%system matrices 
		if count==1
			displaystring(femmodel.parameters.Verbose,'%s',['   system matrices']);
			[K_gg_nopenalty, p_g_nopenalty]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
		end
		displaystring(femmodel.parameters.Verbose,'%s',['   penalty system matrices']);
		[K_gg , p_g, melting_offset]=PenaltySystemMatrices(K_gg_nopenalty,p_g_nopenalty,femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

		%Reduce tangent matrix from g size to f size
		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, femmodel.Gmn, femmodel.nodesets); 

		%Reduce load from g size to f size
		p_f = Reduceloadfromgtof( p_g, femmodel.Gmn, K_fs, femmodel.ys, femmodel.nodesets);

		displaystring(femmodel.parameters.Verbose,'%s%g','   condition number of stiffness matrix: ',condest(K_ff));
		t_f=Solver(K_ff,p_f,[],femmodel.parameters);

		displaystring(femmodel.parameters.Verbose,'%s',['   merging solution back to g set']);
		t_g= Mergesolutionfromftog( t_f, femmodel.Gmn, femmodel.ys, femmodel.nodesets ); 

		displaystring(femmodel.parameters.Verbose,'%s',['   updating inputs']);
		[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,t_g);
	
		%penalty constraints
		displaystring(femmodel.parameters.Verbose,'%s',['   penalty constraints']);
		[femmodel.loads,constraints_converged,num_unstable_constraints] =PenaltyConstraints(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters);
	
		if ~converged,
			displaystring(femmodel.parameters.Verbose,'%s%i','   #unstable constraints ',num_unstable_constraints);
			
			if num_unstable_constraints<=femmodel.parameters.MinThermalConstraints,
				converged=1;
			end
		end

		count=count+1;
	end

	%add melting_offset  into inputs
	[femmodel.elements femmodel.loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,melting_offset,MeltingOffsetEnum);
end

