function femmodel=solver_linear(femmodel)
%SOLVER_LINEAR - core solver of any linear solution sequence
%
%   Usage:
%      femmodel =solver_linear(femmodel)

	%stiffness and load generation only:
	femmodel.parameters.Kflag=1; femmodel.parameters.Pflag=1;

	%system matrices
	[K_gg, p_g]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
	[K_gg, p_g,kmax]=PenaltySystemMatrices(K_gg,p_g,femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
	
	%Reduce tangent matrix from g size to f size
	[K_ff, K_fs] = Reducematrixfromgtof( K_gg, femmodel.Gmn, femmodel.nodesets); 
	displaystring(femmodel.parameters.Verbose>1,'%s%g','      condition number of stiffness matrix: ',condest(K_ff));
	
	%Reduce load from g size to f size
	p_f = Reduceloadfromgtof( p_g, femmodel.Gmn, K_fs, femmodel.ys, femmodel.nodesets);

	%Solve	
	u_f=Solver(K_ff,p_f,[],femmodel.parameters);
	
	%Merge back to g set
	u_g= Mergesolutionfromftog( u_f, femmodel.Gmn, femmodel.ys, femmodel.nodesets ); 

	%Update inputs using new solution
	[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,u_g);

