/*!\file: balancedthickness_core.cpp
 * \brief: core of the balancedthickness solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"
#include "../solvers/solvers.h"

void balancedthickness_core(FemModel* femmodel){

	/*parameters: */
	int verbose=0;
	int dim;
	int solution_type;

	/*activate formulation: */
	femmodel->SetCurrentConfiguration(BalancedthicknessAnalysisEnum);
	
	/*recover parameters: */
	femmodel->parameters->FindParam(&verbose,VerboseEnum);
	femmodel->parameters->FindParam(&dim,DimEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);

	_printf_("depth averaging velocity...\n");
	InputDepthAveragex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VxEnum,VxAverageEnum);
	InputDepthAveragex(femmodel->elements,femmodel->nodes, femmodel->vertices,femmodel->loads, femmodel->materials,femmodel->parameters,VyEnum,VyAverageEnum);

	_printf_("call computational core:\n");
	solver_linear(femmodel);

	if(verbose)_printf_("saving results:\n");
	if(solution_type==BalancedthicknessSolutionEnum){
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,ThicknessEnum);
	}

}
