function updatearchive(varargin)
% This file can be run to update the velocity archives  of the test1.
% This test deals with an icesheet with icefront for a 2d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

% The archive files will be saved in this directory but will not commited to ice1. 
% Just commit the result if you want to.

%packages and misfits to be tested
if nargin==1,
	packages=varargin{1};
else
	packages={'cielo_parallel','cielo_serial'};
end
misfits={'absolute','relative','logarithmic'};

%Initialize log message for nightly runs.
testname='PigControlMethodDragM2d_20';

%go through the solutions requested
for i=1:length(packages),
	package=packages{i};

	for j=1:length(misfits),
		misfit=misfits{j};

		%check package
		if ~(strcmpi(package,'cielo_serial') | strcmpi(package,'cielo_parallel'));
			error(['package: ' package  ' in test: ' testname  ' not supported yet']);
			%check solution
		elseif ~(strcmpi(misfit,'absolute') | strcmpi(misfit,'relative') | strcmpi(misfit,'logarithmic')),
			error(['misfit: ' misfit  ' in test: ' testname  ' not supported yet']);
		end

		%initialize model
		md=model;
		md=mesh(md,'DomainOutline.exp',9000);
		md=geography(md,'Iceshelves.exp','Islands.exp');
		md=parameterize(md,'Pig.par');
		md=setelementstype(md,'macayeal','all');
		if strcmpi(misfit,'absolute'),
			md.fit(:)=0;
		elseif strcmpi(misfit,'relative'),
			md.fit(:)=1;
		elseif strcmpi(misfit,'logarithmic'),
			md.fit(:)=2;
		end
		if strcmpi(package,'cielo_parallel'), md.cluster='wilkes'; end

		%launch control method
		if (strcmpi(package,'cielo_parallel') | strcmpi(package,'cielo_serial')),
			md=solve(md,'analysis_type','control','package','cielo');
		else
			md=solve(md,'analysis_type','control','package',package);
		end

		%compute field to be checked
		fields={'cont_vel','cont_J','cont_parameter'};

		%save new archive
		for k=1:length(fields),
			field=fields{k};
			eval(['Archive' package misfit '_field' num2str(k) '=md.' field  ';']);
		end
		eval(['save Archive' package misfit ' Archive' package misfit '_field*']);
	end
end
