/*! \file  NodeInElement.cpp
*/

#include "./MeshProfileIntersectionx.h"

bool NodeInElement(double* xgrids, double* ygrids, double x, double y){

	double x1,y1;
	double x2,y2;
	double x3,y3;
	double lambda1,lambda2,lambda3;
	double det;

	x1=xgrids[0];
	x2=xgrids[1];
	x3=xgrids[2];
	y1=ygrids[0];
	y2=ygrids[1];
	y3=ygrids[2];


	/*compute determinant: */
	det=x1*y2-x1*y3-x3*y2-x2*y1+x2*y3+x3*y1;
	
	/*area coordinates: */
	lambda1=((y2-y3)*(x-x3)+(x3-x2)*(y-y3))/det;
	lambda2=((y3-y1)*(x-x3)+(x1-x3)*(y-y3))/det;
	lambda3=1-lambda1-lambda2;

	if( ((lambda1<=1) && (lambda1>=0)) && ((lambda2<=1) && (lambda2>=0)) && ((lambda3<=1) && (lambda3>=0))  )return true;
	else return false;

}
