/*\file InputConvergence.c
 *\brief: processes model inputs from the matlab workspace, and transforms them into datasets or vectors 
 *        that will be used throughout the matlab solution sequences.
 */

#include "./InputConvergence.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){ 

	int i;

	/*inputs: */
	Elements* elements=NULL;
	Nodes* nodes=NULL;
	Vertices* vertices=NULL;
	Loads* loads=NULL;
	Materials* materials=NULL;
	Parameters* parameters=NULL;

	int* field_enums=NULL;
	double* double_fields=NULL;
	int numfields;
	int* criterion_enums=NULL;
	double* double_criterion=NULL;
	double* criterion_values=NULL;
	int numcriterions;

	/* output datasets: */
	bool converged;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InputConvergenceUsage);

	FetchData((DataSet**)&elements,ELEMENTS);
	FetchData((DataSet**)&loads,LOADS);
	FetchData((DataSet**)&nodes,NODES);
	FetchData((DataSet**)&vertices,VERTICES);
	FetchData((DataSet**)&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);

	FetchData(&double_fields,&numfields,FIELDENUMS);
	field_enums=(int*)xmalloc(numfields*sizeof(int));
	for(i=0;i<numfields;i++)field_enums[i]=(int)double_fields[i];

	FetchData(&double_criterion,&numcriterions,CRITERIONENUMS);
	FetchData(&criterion_values,&numcriterions,CRITERIONVALUES);
	criterion_enums=(int*)xmalloc(numcriterions*sizeof(int));
	for(i=0;i<numcriterions;i++)criterion_enums[i]=(int)double_criterion[i];

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);
	
	/*call x code InputConvergencex: */
	converged=InputConvergencex(elements,nodes,vertices,loads,materials,parameters, field_enums,numfields,criterion_enums,criterion_values,numcriterions);

	/*Write output data: */
	WriteData(CONVERGED,converged);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	xfree((void**)&field_enums);
	xfree((void**)&double_fields);
	xfree((void**)&criterion_enums);
	xfree((void**)&double_criterion);
	xfree((void**)&criterion_values);
	
	/*end module: */
	MODULEEND();
}
	
void InputConvergenceUsage(void) {
	_printf_("\n");
	_printf_("   usage: convergence=InputConvergence(elements,nodes,vertices,loads,materials,parameters,fieldenums,criterionenums,criterionvalue)\n");
	_printf_("\n");
}
